// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMECANVASMM_CANVAS_H
#define _LIBGNOMECANVASMM_CANVAS_H

#include <glibmm.h>

// -*- C++ -*-
/* $Id: canvas.hg,v 1.16 2002/04/01 16:54:22 murrayc Exp $ */

/* canvas.h
 * 
 * Copyright (C) 1998 EMC Capital Management Inc.
 * Developed by Havoc Pennington <hp@pobox.com>
 *
 * Copyright (C) 1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomecanvas/gnome-canvas.h>
#include <libgnomecanvasmm/affinetrans.h>
#include <gtkmm/layout.h>
#include <gdkmm/color.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GnomeCanvas GnomeCanvas;
typedef struct _GnomeCanvasClass GnomeCanvasClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Canvas
{ class Canvas_Class; } // namespace Canvas

} // namespace Gnome
namespace Gnome
{

namespace Canvas
{

class Item;
class Group;

//- Canvas functions usually operate in either World coordinates
//- (units for the entire canvas), or Canvas coordinates (pixels starting 
//- at 0,0 in the top left).  There are functions to transform from 
//- one to the other.

class Canvas : public Gtk::Layout
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Canvas CppObjectType;
  typedef Canvas_Class CppClassType;
  typedef GnomeCanvas BaseObjectType;
  typedef GnomeCanvasClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Canvas();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Canvas_Class;
  static CppClassType canvas_class_;

  // noncopyable
  Canvas(const Canvas&);
  Canvas& operator=(const Canvas&);

protected:
  explicit Canvas(const Glib::ConstructParams& construct_params);
  explicit Canvas(GnomeCanvas* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GnomeCanvas*       gobj()       { return reinterpret_cast<GnomeCanvas*>(gobject_); }
  const GnomeCanvas* gobj() const { return reinterpret_cast<GnomeCanvas*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
  virtual void request_update_vfunc();

  //Default Signal Handlers::
  virtual void on_draw_background(const Glib::RefPtr<Gdk::Drawable>& drawable, int x, int y, int width, int height);
  virtual void on_render_background(GnomeCanvasBuf* buf);


private:
;
public:
  Canvas();

  //: Get the root canvas item
  
  Group* root();
           
  //: Limits of scroll region
  
  void set_scroll_region(double x1, double y1, double x2, double y2);

  //: Get limits of scroll region
  
  void get_scroll_region(double& x1, double& y1, double& x2, double& y2);

  
  void set_center_scroll_region(bool center);

  
  bool get_center_scroll_region();

  //: Set the pixels/world coordinates ratio
  //- With no arguments sets to default of 1.0.
  
  void set_pixels_per_unit(double n = 1.0);

  //: Shift window.
  //- Makes a canvas scroll to the specified offsets, given in canvas pixel
  //- units.
  //- The canvas will adjust the view so that it is not outside the scrolling
  //- region.  This function is typically not used, as it is better to hook
  //- scrollbars to the canvas layout's scrolling adjusments.
  
  void scroll_to(int x, int y);

  //: Scroll offsets in canvas pixel coordinates.
  
  void get_scroll_offsets(int& cx, int& cy) const;

  //: Repaint immediately, don't wait for idle loop
  //- normally the canvas queues repainting and does it in an
  //- idle loop
  
  void update_now();

  //: Find an item at a location.
  //- Looks for the item that is under the specified position, which must be
  //- specified in world coordinates.  Arguments are in world coordinates.
  //- Returns 0 if no item is at that
  //- location.
  
  Item* get_item_at(double x, double y);


  //: Repaint small area (internal)
  //- Used only by item implementations. Request an eventual redraw
  //- of the region, which includes x1,y1 but not x2,y2
  
  void request_redraw(int x1, int y1, int x2, int y2);
  //TODO: Investigate ArtUta.
  
  void request_redraw(ArtUta* uta);

  Art::AffineTrans w2c_affine() const;
  

  //: Convert from World to canvas coordinates (units for the entire canvas)
  //: to Canvas coordinates (pixels starting at 0,0 in the top left
  //: of the visible area). The relationship depends on the current
  //: scroll position and the pixels_per_unit ratio (zoom factor)
  
  void w2c(double wx, double wy, int& cx, int& cy) const;
  
  void w2c(double wx, double wy, double& cx, double& cy);

  //: From Canvas to World
  
  void c2w(int cx, int cy, double& wx, double& wy) const;

  //: Convert from Window coordinates to world coordinates.
  //- Window coordinates are based of the widget's GdkWindow.
  //- This is fairly low-level and not generally useful.
  
  void window_to_world (double winx,double winy, double& worldx,double& worldy) const;

  //: Convert from world coordinates to Window coordinates.
  //- Window coordinates are based of the widget's GdkWindow.
  //- This is fairly low-level and not generally useful.
  
  void world_to_window (double worldx, double worldy, double& winx, double& winy) const;

  //: Parse color spec string and allocate it into the GdkColor.
  bool get_color(const Glib::ustring& spec, Gdk::Color& color);
  

/* Allocates a color from the RGB value passed into this function. */
  
  gulong get_color_pixel(guint rgba) const;
  
  void set_stipple_origin(const Glib::RefPtr<Gdk::GC>& gc);
  
  void set_dither(GdkRgbDither dither);
  
  GdkRgbDither get_dither() const;


  //TODO: Look at ArtSVP.
  
  void update_svp(ArtSVP** p_svp, ArtSVP* new_svp);
  
  void update_svp_clip(ArtSVP** p_svp, ArtSVP* new_svp, ArtSVP* clip_svp);

  // The following are simply accessed via the struct in C,
  //  but Federico reports that they are meant to be used.
  //: Get the pixels per unit.
  double get_pixels_per_unit() const;

  //: Draw the background for the area given.
  //- This method is only used for non-antialiased canvases.
  
  /**
   * @par Prototype:
   * <tt>void %draw_background(const Glib::RefPtr<Gdk::Drawable>& drawable, int x, int y, int width, int height)</tt>
   */
  Glib::SignalProxy5<void,const Glib::RefPtr<Gdk::Drawable>&,int,int,int,int> signal_draw_background();

  // Render the background for the buffer given. 
  //- The buf data structure contains both a pointer to a packed 24-bit
  //- RGB array, and the coordinates.
  //- This method is only used for antialiased canvases.
  
  /**
   * @par Prototype:
   * <tt>void %render_background(GnomeCanvasBuf* buf)</tt>
   */
  Glib::SignalProxy1<void,GnomeCanvasBuf*> signal_render_background();

  //: Private Virtual methods for groping the canvas inside bonobo.
  

  // Whether the canvas is in antialiased mode or not.
  Glib::PropertyProxy<bool> property_aa();


};

//: Antialiased Canvas.
//- Constructor takes care of push/pop actions of the colormap.
class CanvasAA : public Canvas
{
  public:
    CanvasAA();
    virtual ~CanvasAA();
};

} /* namespace Canvas */
} /* namespace Gnome */


namespace Glib
{
  /** @relates Gnome::Canvas::Canvas */
  Gnome::Canvas::Canvas* wrap(GnomeCanvas* object, bool take_copy = false);
}
#endif /* _LIBGNOMECANVASMM_CANVAS_H */

