/* $Id: uicomponent.h,v 1.2 2002/06/18 19:50:53 murrayc Exp $ */

/* uicomponent.h
 *
 * Copyright (C) 2002 The libbonobouimm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _BONOBOMM_SERVERS_UICOMPONENT_H
#define _BONOBOMM_SERVERS_UICOMPONENT_H

#include <bonobomm/servers/unknown_cppimpl.h>
#include <glibmm/ustring.h>
#include <map>

namespace Gnome
{

namespace Bonobo
{

namespace Servers
{

class UIComponent :
  public virtual POA_Bonobo::UIComponent,
  public Unknown_CppImpl
{
public:

  UIComponent();
  virtual ~UIComponent();

  //CORBA method implementations:

  //From Bonobo::UIComponent:
  virtual void setContainer(::Bonobo::UIContainer_ptr container) throw (CORBA::SystemException);
  virtual void unsetContainer() throw (CORBA::SystemException);
  virtual char* name() throw (CORBA::SystemException);
  virtual char* describeVerbs() throw (CORBA::SystemException);
  virtual void execVerb(char const *cname) throw (CORBA::SystemException);
  virtual void uiEvent(char const *id,::Bonobo::UIComponent::EventType type, char const *state) throw (CORBA::SystemException);
  virtual void unImplemented() throw (CORBA::SystemException);
  virtual void unImplemented2() throw (CORBA::SystemException);
  virtual void unImplemented3() throw (CORBA::SystemException);
  virtual void unImplemented4() throw (CORBA::SystemException);

  //Helper stuff:
  typedef SigC::Slot0<void> SlotVerbHandler;
  virtual void add_verb_handler(const SlotVerbHandler& slot, const Glib::ustring& verb_name);

protected:
  ::Bonobo::UIContainer_ptr m_container;
  std::string m_name;

  typedef std::map<Glib::ustring, SlotVerbHandler> type_mapSlots;
  type_mapSlots m_mapSlots;
};

} /* namespace Servers */
} /* namespace Bonobo */
} /* namespace Gnome */
	
#endif //_BONOBOMM_SERVERS_UICOMPONENT_H

