%define pygtk_ver 1.99.7
%define buildzvt %(pkg-config libzvt-2.0 && echo 1 || echo 0)
%define zvtversion %(pkg-config --modversion libzvt-2.0)

Summary: The sources for the PyGNOME Python extension module.
Name: gnome-python2
Version: 1.99.7
Release: 2
Source: ftp://ftp.gnome.org/pub/GNOME/stable/sources/gnome-python/gnome-python-%{version}.tar.gz
Copyright: LGPL
Group: Development/Languages
BuildRoot: /var/tmp/gnome-python-root
Packager: James Henstridge <james@daa.com.au>
BuildRequires: pygtk2-devel = %{pygtk_ver}
BuildRequires: python2-devel
BuildRequires: gtk2-devel >= 1.3.13
BuildRequires: libgnomecanvas-devel >= 1.110.0
BuildRequires: libgnome-devel >= 1.110.0
%if %{buildzvt}
BuildRequires: libzvt-devel >= %{zvtversion}
%endif

%description
The gnome-python package contains the source packages for the Python
bindings for GNOME called PyGNOME.

PyGNOME is an extension module for Python that provides access to the
base GNOME libraries, so you have access to more widgets, a simple
configuration interface, and metadata support.

%package applet
Version: %{version}
Summary: Python bindings for GNOME Panel applets.
Group: Development/Languages
Requires: gnome-python2 = %{version}

%description applet
This module contains a wrapper that allows GNOME Panel applets to be
written in Python.

%package capplet
Version: %{version}
Summary: Python bindings for GNOME Panel applets.
Group: Development/Languages
Requires: gnome-python2 = %{version}

%description capplet
This module contains a wrapper that allows GNOME Control Center
capplets to be in Python.

%package canvas
Version: %{version}
Summary: Python bindings for the GNOME Canvas.
Group: Development/Languages
Requires: libgnomecanvas >= 1.110.0
Requires: gtk2 >= 1.3.13
Requires: pygtk2 >= %{pygtk_ver}

%description canvas
This module contains a wrapper that allows use of the GNOME Canvas
in Python.

%package zvt
Version: %{version}
Summary: Python bindings for the ZVT terminal widget.
Group: Development/Languages
Requires: libgnomecanvas >= 1.110.0
Requires: gtk2 >= 1.3.13
Requires: pygtk2 >= %{pygtk_ver}
Requires: libzvt >= %{zvtversion}

%description zvt
This module contains a wrapper that allows use of the ZVT terminal
widget in Python.

%prep
%setup -q -n gnome-python-%{version}
export PYTHON=/usr/bin/python2.2
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{_prefix}

%build
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%files
%defattr(644,root,root,755)
%doc AUTHORS ChangeLog README NEWS
%dir %{_prefix}/lib/python?.?/site-packages/gnome/
%{_prefix}/lib/python?.?/site-packages/gnome/__init__.*
%{_prefix}/lib/python?.?/site-packages/gnome/_gnomemodule.so

%if 0
%files applet

%files capplet
%endif

%files canvas
%defattr(755,root,root,755)
%dir %{_prefix}/lib/python?.?/site-packages/gnome/
%{_prefix}/lib/python?.?/site-packages/gnome/__init__.*
%{_prefix}/lib/python?.?/site-packages/gnome/canvasmodule.so
%defattr(644,root,root,755)
%doc examples/canvas

%if %{buildzvt}
%files zvt
%defattr(755,root,root,755)
%dir %{_prefix}/lib/python?.?/site-packages/gnome/
%{_prefix}/lib/python?.?/site-packages/gnome/__init__.*
%{_prefix}/lib/python?.?/site-packages/gnome/zvtmodule.so
%defattr(644,root,root,755)
%doc examples/zvt
%endif

%changelog
* Mon Nov 26 2001 Matt Wilson <msw@redhat.com>
- subpackages will need __init__ included in them

* Thu Oct 18 2001 Matt Wilson <msw@redhat.com>
- doesn't obsolete pygnome - it can be installed side-by-side
- added _gnomemodule.so to base package filelist

* Mon Oct 15 2001 Matt Wilson <msw@redhat.com>
- added __init__ files to gnome-python main package

* Mon Oct  8 2001 Matt Wilson <msw@redhat.com>
- new gnome-python package based on old pygtk package.
