#! /usr/bin/env python
import pygtk
pygtk.require('2.0')

import gnomeprint, gnomeprint.ui, gtk

def do_print(dialog, job):
    pc = gnomeprint.Context(dialog.get_config())
    job.render(pc)
    pc.close()

def render_to_job(job):
    pc = job.get_context()
    width, height = gnomeprint.job_get_page_size_from_config(job.get_config())
    # <<<begin drawing>>>
    pc.beginpage("1")
    pc.setlinewidth(3.0)
    x1 = width*.1
    x2 = width*.9
    y1 = height*.1
    y2 = height*.9
    pc.rect_stroked(x1, y1, x2 - x1, y2 - y1)
    pc.line_stroked(x1, y1, x2, y2)
    pc.line_stroked(x2, y1, x1, y2)
    pc.showpage()
    # <<<end drawing>>>
    job.close()


def show_preview(dialog):
    job = gnomeprint.Job(dialog.get_config())
    render_to_job(job)
    w = gnomeprint.ui.JobPreview(job, "Print Preview")
    w.set_property('allow-grow', 1)
    w.set_property('allow-shrink', 1)
    w.set_transient_for(dialog)
    w.show_all()


def print_dialog_response(dialog, resp, job):
    if resp == gnomeprint.ui.DIALOG_RESPONSE_PREVIEW:
	show_preview(dialog)
    elif resp == gnomeprint.ui.DIALOG_RESPONSE_CANCEL:
	dialog.destroy()
    elif resp == gnomeprint.ui.DIALOG_RESPONSE_PRINT:
	render_to_job(job)
	do_print(dialog, job)
	dialog.destroy()

def show_print_dialog():
    job = gnomeprint.Job(gnomeprint.config_default())
    dialog = gnomeprint.ui.Dialog(job, "Print...", 0)
    dialog.connect('response', print_dialog_response, job)
    dialog.show()
    return dialog

if __name__ == '__main__':
    dialog = show_print_dialog()
    dialog.connect("destroy", lambda *args: gtk.main_quit())
    gtk.mainloop()

