from config.ConfigManager import ConfigManager
from SensorFactory import SensorFactory
from sensor.DefaultSensor import DefaultSensor
from utils.TargetSettings import TargetSettings
from display.Display import Display
from display import targetregistry
from utils import singleton
from utils.TypeConverter import TypeConverter
from utils.datatypes import *
from utils import dialog

from main import _

from xml import sax
import sys
import os


#
# Class for creating Displays from XML data.
#
class DisplayFactory(sax.handler.ContentHandler):

    def __init__(self):

        self.__abort_flag = 0

        self.__children_stack = [[]]
        self.__nesting_stack = []
        self.__sensors = []
        self.__display = None
        self.__display_settings = None
        self.__id = ""
        self.__sensor_factory = singleton.get(SensorFactory)
        self.__type_converter = TypeConverter()


        self.__type_converter.add_type("module", TYPE_LIST)



    #
    # Parses the given XML data and returns a new Display object.
    #
    def create_display(self, id, data):

        self.__display = Display(id)
        self.__id = id

        self.__abort_flag = 0

        # parse display data
        try:
            sax.parseString(data, self)
        except sax._exceptions.SAXParseException, e:
            print "Parse Error:", e
            self.__abort_flag = 1
            
        if (self.__abort_flag): return None

        # add the sensors
        for id, sensor in self.__sensors:
            self.__display.add_sensor(id, sensor)

        # add the DefaultSensor
        defsensor = DefaultSensor()
        defsensor.set_config_manager(singleton.get(ConfigManager),
                                     self.__id + "_default_")
        self.__display.add_sensor("_default_", defsensor)
        self.__display_settings.set("watch", "x=_default_:x,"
                                             "y=_default_:y")


        # add the children and configure
        try:
            self.__display.add_children(self.__children_stack.pop())
            for key, value in self.__display_settings.get_entries():
                self.__display.set_config(key, value)
                
        except StandardError, e:
            # make the corrupt display visible so that the user can
            # remove it
            self.__display.show()
            self.__display.set_decorated(1)
            self.__display.set_size_request(200, 100)
            self.__display.set_title("broken display")
            print "Error while configuring display:" + str(e)
            dialog.warning(_("Error while configuring display"),
                           _("A display could not be configured properly. "
                             "It will most likely be broken and you should "
                             "consider removing it."))
                
        #end try

        return self.__display



    #
    # Creates a TargetSettings object from the given Attributes object.
    #
    def __create_settings(self, attrs):

        settings = TargetSettings()
        for key, value in attrs.items():
            if (key in ["uri", "bg-uri"]):
                value = os.path.abspath(value)
            settings.set(key, value)
        #end for

        return settings

        



    def startElement(self, name, attrs):

        if (name == "display"):
            self.__children_stack = [[]]
            self.__nesting_stack = []
            self.__sensors = []
            self.__display_settings = self.__create_settings(attrs)
        
        elif (name == "sensor"):
            id = attrs["id"]
            moduledata = self.__type_converter.str2type("module",
                                                        attrs["module"])
            module = moduledata[0]
            args = moduledata[1:]
            sensor = self.__sensor_factory.create_sensor(module, args)
            if (not sensor):
                self.__abort_flag = 1
            else:
                sensor.set_config_manager(singleton.get(ConfigManager),
                                          self.__id + id)
                self.__sensors.append((id, sensor))

        else:
            settings = self.__create_settings(attrs)
            # if there is no ID given, guess a unique one
            id = attrs.get("id", str(settings))
            self.__children_stack.append([])
            # remember everything for later
            self.__nesting_stack.append((name, id, settings))




    def endElement(self, name):

        if (name in ["display", "sensor"]): return

        oname, id, settings = self.__nesting_stack.pop()
        if (not name == oname):
            # nesting errors in XML are detected by the SAX parser; if we get
            # here, it means our parser is buggy, not the XML input
            print "Nesting error: expected " + oname + ", got " + name
            return

        clss = targetregistry.get_target_class(name)
        if (not clss):
            print "Unknown tag: " + name

        else:
            children = self.__children_stack.pop()
            self.__children_stack[-1].append((id, clss, settings, children))
