from main import _

import gtk


class DisplayConfigurator(gtk.Dialog):

    def __init__(self, sensorconfigurators):

        gtk.Dialog.__init__(self)
        self.set_title(_("Configuration"))
        self.connect("delete-event", self.__on_close)
        self.set_has_separator(0)
        self.set_border_width(5)
        self.vbox.set_spacing(2)

        # close button
        btn = self.add_button(gtk.STOCK_CLOSE, 0)
        btn.connect("clicked", self.__on_close)

        notebook = gtk.Notebook()
        notebook.show()
        notebook.set_border_width(5)
        self.vbox.pack_start(notebook, gtk.TRUE, gtk.TRUE, 0)

        have_config = 0
        for c in sensorconfigurators:
            if (c):
                have_config = 1
                lbl = gtk.Label(c.get_name())
                lbl.show()
                notebook.append_page(c, lbl)

        if (not have_config):
            lbl = gtk.Label(_("This display is not configurable."))
            lbl.show()
            tab = gtk.Label("")
            tab.show()
            notebook.append_page(lbl, tab)

        self.show()



    #
    # Reacts on closing the window.
    #
    def __on_close(self, *args):

        self.destroy()
        return gtk.TRUE
