/* command-linking.c generated by valac 0.14.0.51-f9a867, the Vala compiler
 * generated from command-linking.vala, do not modify */

/*
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdio.h>
#include <readline/readline.h>


#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
typedef struct _FolksInspectCommandPrivate FolksInspectCommandPrivate;

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_LINKING (folks_inspect_commands_linking_get_type ())
#define FOLKS_INSPECT_COMMANDS_LINKING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinking))
#define FOLKS_INSPECT_COMMANDS_LINKING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinkingClass))
#define FOLKS_INSPECT_COMMANDS_IS_LINKING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING))
#define FOLKS_INSPECT_COMMANDS_IS_LINKING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_LINKING))
#define FOLKS_INSPECT_COMMANDS_LINKING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinkingClass))

typedef struct _FolksInspectCommandsLinking FolksInspectCommandsLinking;
typedef struct _FolksInspectCommandsLinkingClass FolksInspectCommandsLinkingClass;
typedef struct _FolksInspectCommandsLinkingPrivate FolksInspectCommandsLinkingPrivate;
typedef struct _Block1Data Block1Data;
#define _folks_inspect_command_unref0(var) ((var == NULL) ? NULL : (var = (folks_inspect_command_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;

struct _FolksInspectCommand {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectCommandPrivate * priv;
	FolksInspectClient* client;
};

struct _FolksInspectCommandClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectCommand *self);
	void (*run) (FolksInspectCommand* self, const gchar* command_string);
	gchar** (*complete_subcommand) (FolksInspectCommand* self, const gchar* subcommand, int* result_length1);
	const gchar* (*get_name) (FolksInspectCommand* self);
	const gchar* (*get_description) (FolksInspectCommand* self);
	const gchar* (*get_help) (FolksInspectCommand* self);
};

struct _FolksInspectCommandsLinking {
	FolksInspectCommand parent_instance;
	FolksInspectCommandsLinkingPrivate * priv;
};

struct _FolksInspectCommandsLinkingClass {
	FolksInspectCommandClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	FolksInspectCommandsLinking * self;
	GeeHashSet* personas;
};

struct _Block2Data {
	int _ref_count_;
	FolksInspectCommandsLinking * self;
	FolksIndividual* ind;
};


static gpointer folks_inspect_commands_linking_parent_class = NULL;
static gchar** folks_inspect_commands_linking_subcommand_completions;
static gchar** folks_inspect_commands_linking_subcommand_completions = NULL;
static guint folks_inspect_commands_linking_completion_count;
static guint folks_inspect_commands_linking_completion_count = 0U;
static gchar* folks_inspect_commands_linking_prefix;
static gchar* folks_inspect_commands_linking_prefix = NULL;

gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
GType folks_inspect_client_get_type (void) G_GNUC_CONST;
GType folks_inspect_commands_linking_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_INSPECT_COMMANDS_LINKING_DUMMY_PROPERTY
};
FolksInspectCommandsLinking* folks_inspect_commands_linking_new (FolksInspectClient* client);
FolksInspectCommandsLinking* folks_inspect_commands_linking_construct (GType object_type, FolksInspectClient* client);
FolksInspectCommand* folks_inspect_command_construct (GType object_type, FolksInspectClient* client);
static void folks_inspect_commands_linking_real_run (FolksInspectCommand* base, const gchar* command_string);
void folks_inspect_utils_print_line (const gchar* format, ...);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
static void ___lambda4_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ____lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void ____lambda5_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res);
static void _____lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gchar* folks_inspect_commands_linking_subcommand_name_completion_cb (const gchar* word, gint state);
gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state);
static gchar* _folks_inspect_utils_persona_uid_completion_cb_rl_compentry_func_t (const gchar* str, gint a);
static gchar** _vala_array_dup4 (gchar** self, int length);
gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state);
static gchar* _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t (const gchar* str, gint a);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gchar** _vala_array_dup6 (gchar** self, int length);
static gchar** folks_inspect_commands_linking_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1);
static gchar* _folks_inspect_commands_linking_subcommand_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a);
static gchar** _vala_array_dup7 (gchar** self, int length);
static void folks_inspect_commands_linking_finalize (FolksInspectCommand* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


FolksInspectCommandsLinking* folks_inspect_commands_linking_construct (GType object_type, FolksInspectClient* client) {
	FolksInspectCommandsLinking* self = NULL;
	FolksInspectClient* _tmp0_;
	g_return_val_if_fail (client != NULL, NULL);
	_tmp0_ = client;
	self = (FolksInspectCommandsLinking*) folks_inspect_command_construct (object_type, _tmp0_);
	return self;
}


FolksInspectCommandsLinking* folks_inspect_commands_linking_new (FolksInspectClient* client) {
	return folks_inspect_commands_linking_construct (FOLKS_INSPECT_COMMANDS_TYPE_LINKING, client);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_folks_inspect_command_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->personas);
		g_slice_free (Block1Data, _data1_);
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void ___lambda4_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	FolksInspectCommandsLinking * self;
	GeeHashSet* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		FolksInspectClient* _tmp0_;
		FolksIndividualAggregator* _tmp1_;
		FolksIndividualAggregator* _tmp2_;
		GAsyncResult* _tmp3_;
		_tmp0_ = ((FolksInspectCommand*) self)->client;
		_tmp1_ = folks_inspect_client_get_aggregator (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = res;
		folks_individual_aggregator_link_personas_finish (_tmp2_, _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
				goto __catch0_folks_individual_aggregator_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally0;
	__catch0_folks_individual_aggregator_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		GQuark _tmp5_;
		GError* _tmp6_;
		gint _tmp7_;
		GeeHashSet* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->domain;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->code;
		_tmp8_ = _data1_->personas;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		folks_inspect_utils_print_line ("Error (domain: %u, code: %u) linking %u " "personas: %s", _tmp5_, _tmp7_, _tmp10_, _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = _data1_->personas;
	_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	folks_inspect_utils_print_line ("Linking of %u personas was successful.", (guint) _tmp15_);
}


static void ____lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda4_ (self, source_object, res);
	block1_data_unref (self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_folks_inspect_command_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->ind);
		g_slice_free (Block2Data, _data2_);
	}
}


static void ____lambda5_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res) {
	FolksInspectCommandsLinking * self;
	FolksIndividual* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		FolksInspectClient* _tmp0_;
		FolksIndividualAggregator* _tmp1_;
		FolksIndividualAggregator* _tmp2_;
		GAsyncResult* _tmp3_;
		_tmp0_ = ((FolksInspectCommand*) self)->client;
		_tmp1_ = folks_inspect_client_get_aggregator (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = res;
		folks_individual_aggregator_unlink_individual_finish (_tmp2_, _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		GQuark _tmp5_;
		GError* _tmp6_;
		gint _tmp7_;
		FolksIndividual* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->domain;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->code;
		_tmp8_ = _data2_->ind;
		_tmp9_ = folks_individual_get_id (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		folks_inspect_utils_print_line ("Error (domain: %u, code: %u) unlinking " "individual '%s': %s", _tmp5_, _tmp7_, _tmp10_, _tmp12_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = _data2_->ind;
	_tmp14_ = folks_individual_get_id (_tmp13_);
	_tmp15_ = _tmp14_;
	folks_inspect_utils_print_line ("Unlinking of individual '%s' was successful.", _tmp15_);
}


static void _____lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	____lambda5_ (self, source_object, res);
	block2_data_unref (self);
}


static void folks_inspect_commands_linking_real_run (FolksInspectCommand* base, const gchar* command_string) {
	FolksInspectCommandsLinking * self;
	gchar** _tmp0_ = NULL;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	const gchar* _tmp1_;
	gboolean _tmp5_ = FALSE;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gboolean _tmp17_;
	gboolean _tmp19_ = FALSE;
	gchar** _tmp20_;
	gint _tmp20__length1;
	const gchar* _tmp21_;
	gboolean _tmp24_;
	self = (FolksInspectCommandsLinking*) base;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	parts = _tmp0_;
	parts_length1 = 0;
	_parts_size_ = parts_length1;
	_tmp1_ = command_string;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_ = NULL;
		_tmp2_ = command_string;
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		parts = _tmp4_;
		parts_length1 = _vala_array_length (_tmp3_);
		_parts_size_ = parts_length1;
	}
	_tmp6_ = parts;
	_tmp6__length1 = parts_length1;
	if (_tmp6__length1 < 1) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gboolean _tmp13_;
		gboolean _tmp16_;
		_tmp9_ = parts;
		_tmp9__length1 = parts_length1;
		_tmp10_ = _tmp9_[0];
		if (g_strcmp0 (_tmp10_, "link-personas") != 0) {
			gchar** _tmp11_;
			gint _tmp11__length1;
			const gchar* _tmp12_;
			_tmp11_ = parts;
			_tmp11__length1 = parts_length1;
			_tmp12_ = _tmp11_[0];
			_tmp8_ = g_strcmp0 (_tmp12_, "link-individuals") != 0;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp13_ = _tmp8_;
		if (_tmp13_) {
			gchar** _tmp14_;
			gint _tmp14__length1;
			const gchar* _tmp15_;
			_tmp14_ = parts;
			_tmp14__length1 = parts_length1;
			_tmp15_ = _tmp14_[0];
			_tmp7_ = g_strcmp0 (_tmp15_, "unlink-individual") != 0;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp16_ = _tmp7_;
		_tmp5_ = _tmp16_;
	}
	_tmp17_ = _tmp5_;
	if (_tmp17_) {
		const gchar* _tmp18_;
		_tmp18_ = command_string;
		folks_inspect_utils_print_line ("Unrecognised 'linking' command '%s'.", _tmp18_);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp20_ = parts;
	_tmp20__length1 = parts_length1;
	_tmp21_ = _tmp20_[0];
	if (g_strcmp0 (_tmp21_, "link-personas") == 0) {
		_tmp19_ = TRUE;
	} else {
		gchar** _tmp22_;
		gint _tmp22__length1;
		const gchar* _tmp23_;
		_tmp22_ = parts;
		_tmp22__length1 = parts_length1;
		_tmp23_ = _tmp22_[0];
		_tmp19_ = g_strcmp0 (_tmp23_, "link-individuals") == 0;
	}
	_tmp24_ = _tmp19_;
	if (_tmp24_) {
		Block1Data* _data1_;
		GeeHashSet* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		FolksInspectClient* _tmp127_;
		FolksIndividualAggregator* _tmp128_;
		FolksIndividualAggregator* _tmp129_;
		GeeHashSet* _tmp130_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = folks_inspect_command_ref (self);
		_tmp25_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
		_data1_->personas = _tmp25_;
		_tmp26_ = parts;
		_tmp26__length1 = parts_length1;
		if (_tmp26__length1 < 2) {
			gchar** _tmp27_;
			gint _tmp27__length1;
			const gchar* _tmp28_;
			_tmp27_ = parts;
			_tmp27__length1 = parts_length1;
			_tmp28_ = _tmp27_[0];
			if (g_strcmp0 (_tmp28_, "link-personas") == 0) {
				folks_inspect_utils_print_line ("%s", "Must pass at least one persona to a " "'link-personas' subcommand.");
			} else {
				folks_inspect_utils_print_line ("%s", "Must pass at least one individual to a " "'link-individuals' subcommand.");
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			return;
		}
		{
			guint i;
			i = (guint) 1;
			{
				gboolean _tmp29_;
				_tmp29_ = TRUE;
				while (TRUE) {
					gboolean _tmp30_;
					guint _tmp32_;
					gchar** _tmp33_;
					gint _tmp33__length1;
					gboolean _tmp34_ = FALSE;
					gchar** _tmp35_;
					gint _tmp35__length1;
					guint _tmp36_;
					const gchar* _tmp37_;
					gboolean _tmp43_;
					gboolean found;
					gchar** _tmp52_;
					gint _tmp52__length1;
					const gchar* _tmp53_;
					_tmp30_ = _tmp29_;
					if (!_tmp30_) {
						guint _tmp31_;
						_tmp31_ = i;
						i = _tmp31_ + 1;
					}
					_tmp29_ = FALSE;
					_tmp32_ = i;
					_tmp33_ = parts;
					_tmp33__length1 = parts_length1;
					if (!(_tmp32_ < ((guint) _tmp33__length1))) {
						break;
					}
					_tmp35_ = parts;
					_tmp35__length1 = parts_length1;
					_tmp36_ = i;
					_tmp37_ = _tmp35_[_tmp36_];
					if (_tmp37_ == NULL) {
						_tmp34_ = TRUE;
					} else {
						gchar** _tmp38_;
						gint _tmp38__length1;
						guint _tmp39_;
						const gchar* _tmp40_;
						gchar* _tmp41_ = NULL;
						gchar* _tmp42_;
						_tmp38_ = parts;
						_tmp38__length1 = parts_length1;
						_tmp39_ = i;
						_tmp40_ = _tmp38_[_tmp39_];
						_tmp41_ = string_strip (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp34_ = g_strcmp0 (_tmp42_, "") == 0;
						_g_free0 (_tmp42_);
					}
					_tmp43_ = _tmp34_;
					if (_tmp43_) {
						gchar** _tmp44_;
						gint _tmp44__length1;
						const gchar* _tmp45_;
						_tmp44_ = parts;
						_tmp44__length1 = parts_length1;
						_tmp45_ = _tmp44_[0];
						if (g_strcmp0 (_tmp45_, "link-personas") == 0) {
							gchar** _tmp46_;
							gint _tmp46__length1;
							guint _tmp47_;
							const gchar* _tmp48_;
							_tmp46_ = parts;
							_tmp46__length1 = parts_length1;
							_tmp47_ = i;
							_tmp48_ = _tmp46_[_tmp47_];
							folks_inspect_utils_print_line ("Unrecognised persona UID '%s'.", _tmp48_);
						} else {
							gchar** _tmp49_;
							gint _tmp49__length1;
							guint _tmp50_;
							const gchar* _tmp51_;
							_tmp49_ = parts;
							_tmp49__length1 = parts_length1;
							_tmp50_ = i;
							_tmp51_ = _tmp49_[_tmp50_];
							folks_inspect_utils_print_line ("Unrecognised individual ID '%s'.", _tmp51_);
						}
						block1_data_unref (_data1_);
						_data1_ = NULL;
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return;
					}
					found = FALSE;
					_tmp52_ = parts;
					_tmp52__length1 = parts_length1;
					_tmp53_ = _tmp52_[0];
					if (g_strcmp0 (_tmp53_, "link-personas") == 0) {
						gchar** _tmp54_;
						gint _tmp54__length1;
						guint _tmp55_;
						const gchar* _tmp56_;
						gchar* _tmp57_ = NULL;
						gchar* uid;
						gboolean _tmp87_;
						_tmp54_ = parts;
						_tmp54__length1 = parts_length1;
						_tmp55_ = i;
						_tmp56_ = _tmp54_[_tmp55_];
						_tmp57_ = string_strip (_tmp56_);
						uid = _tmp57_;
						{
							FolksInspectClient* _tmp58_;
							FolksIndividualAggregator* _tmp59_;
							FolksIndividualAggregator* _tmp60_;
							GeeMap* _tmp61_;
							GeeMap* _tmp62_;
							GeeCollection* _tmp63_;
							GeeCollection* _tmp64_;
							GeeCollection* _tmp65_;
							GeeIterator* _tmp66_ = NULL;
							GeeIterator* _tmp67_;
							GeeIterator* _individual_it;
							_tmp58_ = ((FolksInspectCommand*) self)->client;
							_tmp59_ = folks_inspect_client_get_aggregator (_tmp58_);
							_tmp60_ = _tmp59_;
							_tmp61_ = folks_individual_aggregator_get_individuals (_tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = gee_map_get_values (_tmp62_);
							_tmp64_ = _tmp63_;
							_tmp65_ = _tmp64_;
							_tmp66_ = gee_iterable_iterator ((GeeIterable*) _tmp65_);
							_tmp67_ = _tmp66_;
							_g_object_unref0 (_tmp65_);
							_individual_it = _tmp67_;
							while (TRUE) {
								GeeIterator* _tmp68_;
								gboolean _tmp69_ = FALSE;
								GeeIterator* _tmp70_;
								gpointer _tmp71_ = NULL;
								FolksIndividual* individual;
								gboolean _tmp86_;
								_tmp68_ = _individual_it;
								_tmp69_ = gee_iterator_next (_tmp68_);
								if (!_tmp69_) {
									break;
								}
								_tmp70_ = _individual_it;
								_tmp71_ = gee_iterator_get (_tmp70_);
								individual = (FolksIndividual*) _tmp71_;
								{
									FolksIndividual* _tmp72_;
									GeeSet* _tmp73_;
									GeeSet* _tmp74_;
									GeeIterator* _tmp75_ = NULL;
									GeeIterator* _persona_it;
									_tmp72_ = individual;
									_tmp73_ = folks_individual_get_personas (_tmp72_);
									_tmp74_ = _tmp73_;
									_tmp75_ = gee_iterable_iterator ((GeeIterable*) _tmp74_);
									_persona_it = _tmp75_;
									while (TRUE) {
										GeeIterator* _tmp76_;
										gboolean _tmp77_ = FALSE;
										GeeIterator* _tmp78_;
										gpointer _tmp79_ = NULL;
										FolksPersona* persona;
										FolksPersona* _tmp80_;
										const gchar* _tmp81_;
										const gchar* _tmp82_;
										const gchar* _tmp83_;
										_tmp76_ = _persona_it;
										_tmp77_ = gee_iterator_next (_tmp76_);
										if (!_tmp77_) {
											break;
										}
										_tmp78_ = _persona_it;
										_tmp79_ = gee_iterator_get (_tmp78_);
										persona = (FolksPersona*) _tmp79_;
										_tmp80_ = persona;
										_tmp81_ = folks_persona_get_uid (_tmp80_);
										_tmp82_ = _tmp81_;
										_tmp83_ = uid;
										if (g_strcmp0 (_tmp82_, _tmp83_) == 0) {
											GeeHashSet* _tmp84_;
											FolksPersona* _tmp85_;
											_tmp84_ = _data1_->personas;
											_tmp85_ = persona;
											gee_abstract_collection_add ((GeeAbstractCollection*) _tmp84_, _tmp85_);
											found = TRUE;
											_g_object_unref0 (persona);
											break;
										}
										_g_object_unref0 (persona);
									}
									_g_object_unref0 (_persona_it);
								}
								_tmp86_ = found;
								if (_tmp86_ == TRUE) {
									_g_object_unref0 (individual);
									break;
								}
								_g_object_unref0 (individual);
							}
							_g_object_unref0 (_individual_it);
						}
						_tmp87_ = found;
						if (_tmp87_ == FALSE) {
							gchar** _tmp88_;
							gint _tmp88__length1;
							guint _tmp89_;
							const gchar* _tmp90_;
							_tmp88_ = parts;
							_tmp88__length1 = parts_length1;
							_tmp89_ = i;
							_tmp90_ = _tmp88_[_tmp89_];
							folks_inspect_utils_print_line ("Unrecognised persona UID '%s'.", _tmp90_);
							_g_free0 (uid);
							block1_data_unref (_data1_);
							_data1_ = NULL;
							parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
							return;
						}
						_g_free0 (uid);
					} else {
						gchar** _tmp91_;
						gint _tmp91__length1;
						guint _tmp92_;
						const gchar* _tmp93_;
						gchar* _tmp94_ = NULL;
						gchar* id;
						gboolean _tmp123_;
						_tmp91_ = parts;
						_tmp91__length1 = parts_length1;
						_tmp92_ = i;
						_tmp93_ = _tmp91_[_tmp92_];
						_tmp94_ = string_strip (_tmp93_);
						id = _tmp94_;
						{
							FolksInspectClient* _tmp95_;
							FolksIndividualAggregator* _tmp96_;
							FolksIndividualAggregator* _tmp97_;
							GeeMap* _tmp98_;
							GeeMap* _tmp99_;
							GeeCollection* _tmp100_;
							GeeCollection* _tmp101_;
							GeeCollection* _tmp102_;
							GeeIterator* _tmp103_ = NULL;
							GeeIterator* _tmp104_;
							GeeIterator* _individual_it;
							_tmp95_ = ((FolksInspectCommand*) self)->client;
							_tmp96_ = folks_inspect_client_get_aggregator (_tmp95_);
							_tmp97_ = _tmp96_;
							_tmp98_ = folks_individual_aggregator_get_individuals (_tmp97_);
							_tmp99_ = _tmp98_;
							_tmp100_ = gee_map_get_values (_tmp99_);
							_tmp101_ = _tmp100_;
							_tmp102_ = _tmp101_;
							_tmp103_ = gee_iterable_iterator ((GeeIterable*) _tmp102_);
							_tmp104_ = _tmp103_;
							_g_object_unref0 (_tmp102_);
							_individual_it = _tmp104_;
							while (TRUE) {
								GeeIterator* _tmp105_;
								gboolean _tmp106_ = FALSE;
								GeeIterator* _tmp107_;
								gpointer _tmp108_ = NULL;
								FolksIndividual* individual;
								FolksIndividual* _tmp109_;
								const gchar* _tmp110_;
								const gchar* _tmp111_;
								const gchar* _tmp112_;
								_tmp105_ = _individual_it;
								_tmp106_ = gee_iterator_next (_tmp105_);
								if (!_tmp106_) {
									break;
								}
								_tmp107_ = _individual_it;
								_tmp108_ = gee_iterator_get (_tmp107_);
								individual = (FolksIndividual*) _tmp108_;
								_tmp109_ = individual;
								_tmp110_ = folks_individual_get_id (_tmp109_);
								_tmp111_ = _tmp110_;
								_tmp112_ = id;
								if (g_strcmp0 (_tmp111_, _tmp112_) == 0) {
									{
										FolksIndividual* _tmp113_;
										GeeSet* _tmp114_;
										GeeSet* _tmp115_;
										GeeIterator* _tmp116_ = NULL;
										GeeIterator* _persona_it;
										_tmp113_ = individual;
										_tmp114_ = folks_individual_get_personas (_tmp113_);
										_tmp115_ = _tmp114_;
										_tmp116_ = gee_iterable_iterator ((GeeIterable*) _tmp115_);
										_persona_it = _tmp116_;
										while (TRUE) {
											GeeIterator* _tmp117_;
											gboolean _tmp118_ = FALSE;
											GeeIterator* _tmp119_;
											gpointer _tmp120_ = NULL;
											FolksPersona* persona;
											GeeHashSet* _tmp121_;
											FolksPersona* _tmp122_;
											_tmp117_ = _persona_it;
											_tmp118_ = gee_iterator_next (_tmp117_);
											if (!_tmp118_) {
												break;
											}
											_tmp119_ = _persona_it;
											_tmp120_ = gee_iterator_get (_tmp119_);
											persona = (FolksPersona*) _tmp120_;
											_tmp121_ = _data1_->personas;
											_tmp122_ = persona;
											gee_abstract_collection_add ((GeeAbstractCollection*) _tmp121_, _tmp122_);
											_g_object_unref0 (persona);
										}
										_g_object_unref0 (_persona_it);
									}
									found = TRUE;
									_g_object_unref0 (individual);
									break;
								}
								_g_object_unref0 (individual);
							}
							_g_object_unref0 (_individual_it);
						}
						_tmp123_ = found;
						if (_tmp123_ == FALSE) {
							gchar** _tmp124_;
							gint _tmp124__length1;
							guint _tmp125_;
							const gchar* _tmp126_;
							_tmp124_ = parts;
							_tmp124__length1 = parts_length1;
							_tmp125_ = i;
							_tmp126_ = _tmp124_[_tmp125_];
							folks_inspect_utils_print_line ("Unrecognised individual ID '%s'.", _tmp126_);
							_g_free0 (id);
							block1_data_unref (_data1_);
							_data1_ = NULL;
							parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
							return;
						}
						_g_free0 (id);
					}
				}
			}
		}
		_tmp127_ = ((FolksInspectCommand*) self)->client;
		_tmp128_ = folks_inspect_client_get_aggregator (_tmp127_);
		_tmp129_ = _tmp128_;
		_tmp130_ = _data1_->personas;
		folks_individual_aggregator_link_personas (_tmp129_, (GeeSet*) _tmp130_, ____lambda4__gasync_ready_callback, block1_data_ref (_data1_));
		block1_data_unref (_data1_);
		_data1_ = NULL;
	} else {
		gchar** _tmp131_;
		gint _tmp131__length1;
		const gchar* _tmp132_;
		_tmp131_ = parts;
		_tmp131__length1 = parts_length1;
		_tmp132_ = _tmp131_[0];
		if (g_strcmp0 (_tmp132_, "unlink-individual") == 0) {
			Block2Data* _data2_;
			gchar** _tmp133_;
			gint _tmp133__length1;
			FolksInspectClient* _tmp134_;
			FolksIndividualAggregator* _tmp135_;
			FolksIndividualAggregator* _tmp136_;
			GeeMap* _tmp137_;
			GeeMap* _tmp138_;
			gchar** _tmp139_;
			gint _tmp139__length1;
			const gchar* _tmp140_;
			gpointer _tmp141_ = NULL;
			FolksIndividual* _tmp142_;
			FolksInspectClient* _tmp145_;
			FolksIndividualAggregator* _tmp146_;
			FolksIndividualAggregator* _tmp147_;
			FolksIndividual* _tmp148_;
			_data2_ = g_slice_new0 (Block2Data);
			_data2_->_ref_count_ = 1;
			_data2_->self = folks_inspect_command_ref (self);
			_tmp133_ = parts;
			_tmp133__length1 = parts_length1;
			if (_tmp133__length1 != 2) {
				folks_inspect_utils_print_line ("%s", "Must pass exactly one individual ID to an " "'unlink-individual' subcommand.");
				block2_data_unref (_data2_);
				_data2_ = NULL;
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				return;
			}
			_tmp134_ = ((FolksInspectCommand*) self)->client;
			_tmp135_ = folks_inspect_client_get_aggregator (_tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = folks_individual_aggregator_get_individuals (_tmp136_);
			_tmp138_ = _tmp137_;
			_tmp139_ = parts;
			_tmp139__length1 = parts_length1;
			_tmp140_ = _tmp139_[1];
			_tmp141_ = gee_map_get (_tmp138_, _tmp140_);
			_data2_->ind = (FolksIndividual*) _tmp141_;
			_tmp142_ = _data2_->ind;
			if (_tmp142_ == NULL) {
				gchar** _tmp143_;
				gint _tmp143__length1;
				const gchar* _tmp144_;
				_tmp143_ = parts;
				_tmp143__length1 = parts_length1;
				_tmp144_ = _tmp143_[1];
				folks_inspect_utils_print_line ("Unrecognised individual ID '%s'.", _tmp144_);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				return;
			}
			_tmp145_ = ((FolksInspectCommand*) self)->client;
			_tmp146_ = folks_inspect_client_get_aggregator (_tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = _data2_->ind;
			folks_individual_aggregator_unlink_individual (_tmp147_, _tmp148_, _____lambda5__gasync_ready_callback, block2_data_ref (_data2_));
			block2_data_unref (_data2_);
			_data2_ = NULL;
		} else {
			g_assert_not_reached ();
		}
	}
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
}


static gchar* _folks_inspect_utils_persona_uid_completion_cb_rl_compentry_func_t (const gchar* str, gint a) {
	gchar* result;
	result = folks_inspect_utils_persona_uid_completion_cb (str, a);
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar* _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t (const gchar* str, gint a) {
	gchar* result;
	result = folks_inspect_utils_individual_id_completion_cb (str, a);
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gchar* folks_inspect_commands_linking_subcommand_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar* _tmp72_;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		const gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_ = NULL;
		gchar** parts;
		gint parts_length1;
		gint _parts_size_;
		gboolean _tmp4_ = FALSE;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gboolean _tmp12_;
		_tmp1_ = word;
		_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
		parts = _tmp3_;
		parts_length1 = _vala_array_length (_tmp2_);
		_parts_size_ = parts_length1;
		_tmp5_ = parts;
		_tmp5__length1 = parts_length1;
		if (_tmp5__length1 > 0) {
			gboolean _tmp6_ = FALSE;
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			gboolean _tmp11_;
			_tmp7_ = parts;
			_tmp7__length1 = parts_length1;
			_tmp8_ = _tmp7_[0];
			if (g_strcmp0 (_tmp8_, "link-personas") == 0) {
				_tmp6_ = TRUE;
			} else {
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				_tmp9_ = parts;
				_tmp9__length1 = parts_length1;
				_tmp10_ = _tmp9_[0];
				_tmp6_ = g_strcmp0 (_tmp10_, "link-individuals") == 0;
			}
			_tmp11_ = _tmp6_;
			_tmp4_ = _tmp11_;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp12_ = _tmp4_;
		if (_tmp12_) {
			gchar** _tmp13_;
			gint _tmp13__length1;
			gchar** _tmp14_;
			gint _tmp14__length1;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* last_part;
			gchar** _tmp17_;
			gint _tmp17__length1;
			const gchar* _tmp18_;
			const gchar* _tmp27_;
			_tmp13_ = parts;
			_tmp13__length1 = parts_length1;
			_tmp14_ = parts;
			_tmp14__length1 = parts_length1;
			_tmp15_ = _tmp13_[_tmp14__length1 - 1];
			_tmp16_ = g_strdup (_tmp15_);
			last_part = _tmp16_;
			_tmp17_ = parts;
			_tmp17__length1 = parts_length1;
			_tmp18_ = _tmp17_[0];
			if (g_strcmp0 (_tmp18_, "link-personas") == 0) {
				const gchar* _tmp19_;
				gchar** _tmp20_;
				gchar** _tmp21_ = NULL;
				gchar** _tmp22_;
				gint _tmp22__length1;
				_tmp19_ = last_part;
				_tmp21_ = _tmp20_ = rl_completion_matches (_tmp19_, _folks_inspect_utils_persona_uid_completion_cb_rl_compentry_func_t);
				_tmp22_ = (_tmp21_ != NULL) ? _vala_array_dup4 (_tmp21_, _vala_array_length (_tmp20_)) : ((gpointer) _tmp21_);
				_tmp22__length1 = _vala_array_length (_tmp20_);
				folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
				folks_inspect_commands_linking_subcommand_completions = _tmp22_;
			} else {
				const gchar* _tmp23_;
				gchar** _tmp24_;
				gchar** _tmp25_ = NULL;
				gchar** _tmp26_;
				gint _tmp26__length1;
				_tmp23_ = last_part;
				_tmp25_ = _tmp24_ = rl_completion_matches (_tmp23_, _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t);
				_tmp26_ = (_tmp25_ != NULL) ? _vala_array_dup5 (_tmp25_, _vala_array_length (_tmp24_)) : ((gpointer) _tmp25_);
				_tmp26__length1 = _vala_array_length (_tmp24_);
				folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
				folks_inspect_commands_linking_subcommand_completions = _tmp26_;
			}
			_tmp27_ = last_part;
			if (g_strcmp0 (_tmp27_, "") == 0) {
				const gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp28_ = word;
				_tmp29_ = g_strdup (_tmp28_);
				_g_free0 (folks_inspect_commands_linking_prefix);
				folks_inspect_commands_linking_prefix = _tmp29_;
			} else {
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gchar* _tmp34_ = NULL;
				_tmp30_ = word;
				_tmp31_ = last_part;
				_tmp32_ = strlen (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = string_slice (_tmp30_, (glong) 0, (glong) (-_tmp33_));
				_g_free0 (folks_inspect_commands_linking_prefix);
				folks_inspect_commands_linking_prefix = _tmp34_;
			}
			_g_free0 (last_part);
		} else {
			gboolean _tmp35_ = FALSE;
			gchar** _tmp36_;
			gint _tmp36__length1;
			gboolean _tmp39_;
			_tmp36_ = parts;
			_tmp36__length1 = parts_length1;
			if (_tmp36__length1 > 0) {
				gchar** _tmp37_;
				gint _tmp37__length1;
				const gchar* _tmp38_;
				_tmp37_ = parts;
				_tmp37__length1 = parts_length1;
				_tmp38_ = _tmp37_[0];
				_tmp35_ = g_strcmp0 (_tmp38_, "unlink-individual") == 0;
			} else {
				_tmp35_ = FALSE;
			}
			_tmp39_ = _tmp35_;
			if (_tmp39_) {
				gchar** _tmp40_;
				gint _tmp40__length1;
				gchar** _tmp42_;
				gint _tmp42__length1;
				const gchar* _tmp43_;
				gchar** _tmp44_;
				gchar** _tmp45_ = NULL;
				gchar** _tmp46_;
				gint _tmp46__length1;
				gchar* _tmp47_;
				_tmp40_ = parts;
				_tmp40__length1 = parts_length1;
				if (_tmp40__length1 != 2) {
					gchar* _tmp41_;
					folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
					folks_inspect_commands_linking_subcommand_completions = NULL;
					folks_inspect_commands_linking_completion_count = (guint) 0;
					_tmp41_ = g_strdup ("");
					_g_free0 (folks_inspect_commands_linking_prefix);
					folks_inspect_commands_linking_prefix = _tmp41_;
					result = NULL;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp42_ = parts;
				_tmp42__length1 = parts_length1;
				_tmp43_ = _tmp42_[1];
				_tmp45_ = _tmp44_ = rl_completion_matches (_tmp43_, _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t);
				_tmp46_ = (_tmp45_ != NULL) ? _vala_array_dup6 (_tmp45_, _vala_array_length (_tmp44_)) : ((gpointer) _tmp45_);
				_tmp46__length1 = _vala_array_length (_tmp44_);
				folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
				folks_inspect_commands_linking_subcommand_completions = _tmp46_;
				_tmp47_ = g_strdup ("unlink-individual ");
				_g_free0 (folks_inspect_commands_linking_prefix);
				folks_inspect_commands_linking_prefix = _tmp47_;
			} else {
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar** _tmp51_ = NULL;
				gchar* _tmp52_;
				_tmp48_ = g_strdup ("link-personas");
				_tmp49_ = g_strdup ("link-individuals");
				_tmp50_ = g_strdup ("unlink-individual");
				_tmp51_ = g_new0 (gchar*, 4 + 1);
				_tmp51_[0] = _tmp48_;
				_tmp51_[1] = _tmp49_;
				_tmp51_[2] = _tmp50_;
				_tmp51_[3] = NULL;
				folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
				folks_inspect_commands_linking_subcommand_completions = _tmp51_;
				_tmp52_ = g_strdup ("");
				_g_free0 (folks_inspect_commands_linking_prefix);
				folks_inspect_commands_linking_prefix = _tmp52_;
			}
		}
		folks_inspect_commands_linking_completion_count = (guint) 0;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	}
	while (TRUE) {
		guint _tmp53_;
		gchar** _tmp54_;
		gint _tmp54__length1;
		gchar** _tmp55_;
		gint _tmp55__length1;
		guint _tmp56_;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* completion;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* candidate;
		guint _tmp62_;
		gboolean _tmp63_ = FALSE;
		gboolean _tmp64_ = FALSE;
		const gchar* _tmp65_;
		gboolean _tmp67_;
		gboolean _tmp71_;
		_tmp53_ = folks_inspect_commands_linking_completion_count;
		_tmp54_ = folks_inspect_commands_linking_subcommand_completions;
		_tmp54__length1 = _vala_array_length (folks_inspect_commands_linking_subcommand_completions);
		if (!(_tmp53_ < ((guint) _tmp54__length1))) {
			break;
		}
		_tmp55_ = folks_inspect_commands_linking_subcommand_completions;
		_tmp55__length1 = _vala_array_length (folks_inspect_commands_linking_subcommand_completions);
		_tmp56_ = folks_inspect_commands_linking_completion_count;
		_tmp57_ = _tmp55_[_tmp56_];
		_tmp58_ = g_strdup (_tmp57_);
		completion = _tmp58_;
		_tmp59_ = folks_inspect_commands_linking_prefix;
		_tmp60_ = completion;
		_tmp61_ = g_strconcat (_tmp59_, _tmp60_, NULL);
		candidate = _tmp61_;
		_tmp62_ = folks_inspect_commands_linking_completion_count;
		folks_inspect_commands_linking_completion_count = _tmp62_ + 1;
		_tmp65_ = completion;
		if (_tmp65_ != NULL) {
			const gchar* _tmp66_;
			_tmp66_ = completion;
			_tmp64_ = g_strcmp0 (_tmp66_, "") != 0;
		} else {
			_tmp64_ = FALSE;
		}
		_tmp67_ = _tmp64_;
		if (_tmp67_) {
			const gchar* _tmp68_;
			const gchar* _tmp69_;
			gboolean _tmp70_ = FALSE;
			_tmp68_ = candidate;
			_tmp69_ = word;
			_tmp70_ = g_str_has_prefix (_tmp68_, _tmp69_);
			_tmp63_ = _tmp70_;
		} else {
			_tmp63_ = FALSE;
		}
		_tmp71_ = _tmp63_;
		if (_tmp71_) {
			result = completion;
			_g_free0 (candidate);
			return result;
		}
		_g_free0 (candidate);
		_g_free0 (completion);
	}
	folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
	folks_inspect_commands_linking_subcommand_completions = NULL;
	folks_inspect_commands_linking_completion_count = (guint) 0;
	_tmp72_ = g_strdup ("");
	_g_free0 (folks_inspect_commands_linking_prefix);
	folks_inspect_commands_linking_prefix = _tmp72_;
	result = NULL;
	return result;
}


static gchar* _folks_inspect_commands_linking_subcommand_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a) {
	gchar* result;
	result = folks_inspect_commands_linking_subcommand_name_completion_cb (str, a);
	return result;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** folks_inspect_commands_linking_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1) {
	FolksInspectCommandsLinking * self;
	gchar** result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	self = (FolksInspectCommandsLinking*) base;
	g_return_val_if_fail (subcommand != NULL, NULL);
	_tmp0_ = subcommand;
	_tmp2_ = _tmp1_ = rl_completion_matches (_tmp0_, _folks_inspect_commands_linking_subcommand_name_completion_cb_rl_compentry_func_t);
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup7 (_tmp2_, _vala_array_length (_tmp1_)) : ((gpointer) _tmp2_);
	_tmp3__length1 = _vala_array_length (_tmp1_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static const gchar* folks_inspect_commands_linking_real_get_name (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsLinking* self;
	self = (FolksInspectCommandsLinking*) base;
	result = "linking";
	return result;
}


static const gchar* folks_inspect_commands_linking_real_get_description (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsLinking* self;
	self = (FolksInspectCommandsLinking*) base;
	result = "Link and unlink personas";
	return result;
}


static const gchar* folks_inspect_commands_linking_real_get_help (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsLinking* self;
	self = (FolksInspectCommandsLinking*) base;
	result = "linking link-personas [persona 1 UID] " "[persona 2 UID] …           " "Link the given personas.\n" "linking link-individuals [individual 1 ID] " "[individual 2 ID] …    " "Link the personas in the given individuals.\n" "linking unlink-individual " "[individual ID]                         " "Unlink the given individual.";
	return result;
}


static void folks_inspect_commands_linking_class_init (FolksInspectCommandsLinkingClass * klass) {
	folks_inspect_commands_linking_parent_class = g_type_class_peek_parent (klass);
	FOLKS_INSPECT_COMMAND_CLASS (klass)->finalize = folks_inspect_commands_linking_finalize;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->run = folks_inspect_commands_linking_real_run;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->complete_subcommand = folks_inspect_commands_linking_real_complete_subcommand;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_name = folks_inspect_commands_linking_real_get_name;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_description = folks_inspect_commands_linking_real_get_description;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_help = folks_inspect_commands_linking_real_get_help;
}


static void folks_inspect_commands_linking_instance_init (FolksInspectCommandsLinking * self) {
}


static void folks_inspect_commands_linking_finalize (FolksInspectCommand* obj) {
	FolksInspectCommandsLinking * self;
	self = FOLKS_INSPECT_COMMANDS_LINKING (obj);
	FOLKS_INSPECT_COMMAND_CLASS (folks_inspect_commands_linking_parent_class)->finalize (obj);
}


GType folks_inspect_commands_linking_get_type (void) {
	static volatile gsize folks_inspect_commands_linking_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_commands_linking_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectCommandsLinkingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_commands_linking_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectCommandsLinking), 0, (GInstanceInitFunc) folks_inspect_commands_linking_instance_init, NULL };
		GType folks_inspect_commands_linking_type_id;
		folks_inspect_commands_linking_type_id = g_type_register_static (FOLKS_INSPECT_TYPE_COMMAND, "FolksInspectCommandsLinking", &g_define_type_info, 0);
		g_once_init_leave (&folks_inspect_commands_linking_type_id__volatile, folks_inspect_commands_linking_type_id);
	}
	return folks_inspect_commands_linking_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



