/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gnome.h>
#include <libgnomecanvas/libgnomecanvas.h>
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gnome.CanvasGroup
 * Method:    gnome_canvas_group_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasGroup_gnome_1canvas_1group_1get_1type (JNIEnv 
    *env, jclass cls) 
{
    {
        return (jint)gnome_canvas_group_get_type ();
    }
}

/*
 * Class:     org_gnu_gnome_CanvasGroup
 * Method:    get_item_list
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gnome_CanvasGroup_get_1item_1list
  (JNIEnv *env, jclass cls, jint group)
{
	GList *list = ((GnomeCanvasGroup*)group)->item_list;
	guint len;
	jintArray ar;
	int i = 0;
	if (NULL == list)
    	return NULL;
	len = g_list_length(list);
	ar = (*env)->NewIntArray(env, len);
	for (i = 0; i < len; i++) {
		GList *item = g_list_nth(list, i);
		(*env)->SetIntArrayRegion(env, ar, i, 1, (jint*)item->data);
	}
	return ar;
}
                                                                              

#ifdef __cplusplus
}

#endif
