/* bdgpGeneInfo.h was originally generated by the autoSql program, which also 
 * generated bdgpGeneInfo.c and bdgpGeneInfo.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef BDGPGENEINFO_H
#define BDGPGENEINFO_H

#define BDGPGENEINFO_NUM_COLS 6

struct bdgpGeneInfo
/* Berkeley Drosophile Genome Project Protein-Coding Genes track additional information */
    {
    struct bdgpGeneInfo *next;  /* Next in singly linked list. */
    char *bdgpName;	/* BDGP annotation gene name */
    char *flyBaseId;	/* FlyBase FBgn ID */
    char *go;	/* comma-sep list of GO numeric IDs */
    char *symbol;	/* symbolic gene name */
    char *cytorange;	/* cytorange */
    char *cdna_clone;	/* comma-sep list of cdna clone IDs */
    };

void bdgpGeneInfoStaticLoad(char **row, struct bdgpGeneInfo *ret);
/* Load a row from bdgpGeneInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct bdgpGeneInfo *bdgpGeneInfoLoad(char **row);
/* Load a bdgpGeneInfo from row fetched with select * from bdgpGeneInfo
 * from database.  Dispose of this with bdgpGeneInfoFree(). */

struct bdgpGeneInfo *bdgpGeneInfoLoadAll(char *fileName);
/* Load all bdgpGeneInfo from whitespace-separated file.
 * Dispose of this with bdgpGeneInfoFreeList(). */

struct bdgpGeneInfo *bdgpGeneInfoLoadAllByChar(char *fileName, char chopper);
/* Load all bdgpGeneInfo from chopper separated file.
 * Dispose of this with bdgpGeneInfoFreeList(). */

#define bdgpGeneInfoLoadAllByTab(a) bdgpGeneInfoLoadAllByChar(a, '\t');
/* Load all bdgpGeneInfo from tab separated file.
 * Dispose of this with bdgpGeneInfoFreeList(). */

struct bdgpGeneInfo *bdgpGeneInfoCommaIn(char **pS, struct bdgpGeneInfo *ret);
/* Create a bdgpGeneInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bdgpGeneInfo */

void bdgpGeneInfoFree(struct bdgpGeneInfo **pEl);
/* Free a single dynamically allocated bdgpGeneInfo such as created
 * with bdgpGeneInfoLoad(). */

void bdgpGeneInfoFreeList(struct bdgpGeneInfo **pList);
/* Free a list of dynamically allocated bdgpGeneInfo's */

void bdgpGeneInfoOutput(struct bdgpGeneInfo *el, FILE *f, char sep, char lastSep);
/* Print out bdgpGeneInfo.  Separate fields with sep. Follow last field with lastSep. */

#define bdgpGeneInfoTabOut(el,f) bdgpGeneInfoOutput(el,f,'\t','\n');
/* Print out bdgpGeneInfo as a line in a tab-separated file. */

#define bdgpGeneInfoCommaOut(el,f) bdgpGeneInfoOutput(el,f,',',',');
/* Print out bdgpGeneInfo as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* BDGPGENEINFO_H */

