pub const ext = @import("ext.zig");
const gstglwayland = @This();

const std = @import("std");
const compat = @import("compat");
const gstvideo = @import("gstvideo1");
const gstbase = @import("gstbase1");
const gst = @import("gst1");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
const gstgl = @import("gstgl1");
/// the contents of a `gstglwayland.GLDisplayWayland` are private and should only be accessed
/// through the provided API
pub const GLDisplayWayland = extern struct {
    pub const Parent = gstgl.GLDisplay;
    pub const Implements = [_]type{};
    pub const Class = gstglwayland.GLDisplayWaylandClass;
    f_parent: gstgl.GLDisplay,
    f_display: ?*anyopaque,
    f_registry: ?*anyopaque,
    f_compositor: ?*anyopaque,
    f_subcompositor: ?*anyopaque,
    f_shell: ?*anyopaque,
    f_foreign_display: c_int,
    f__padding: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Create a new `gstglwayland.GLDisplayWayland` from the wayland display name.  See `wl_display_connect`()
    /// for details on what is a valid name.
    extern fn gst_gl_display_wayland_new(p_name: ?[*:0]const u8) ?*gstglwayland.GLDisplayWayland;
    pub const new = gst_gl_display_wayland_new;

    /// Creates a new display connection from a wl_display Display.
    extern fn gst_gl_display_wayland_new_with_display(p_display: ?*anyopaque) *gstglwayland.GLDisplayWayland;
    pub const newWithDisplay = gst_gl_display_wayland_new_with_display;

    extern fn gst_gl_display_wayland_get_type() usize;
    pub const getGObjectType = gst_gl_display_wayland_get_type;

    extern fn g_object_ref(p_self: *gstglwayland.GLDisplayWayland) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstglwayland.GLDisplayWayland) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GLDisplayWayland, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const GLDisplayWaylandClass = extern struct {
    pub const Instance = gstglwayland.GLDisplayWayland;

    f_object_class: gstgl.GLDisplayClass,
    f__padding: [4]*anyopaque,

    pub fn as(p_instance: *GLDisplayWaylandClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};
