pub const ext = @import("ext.zig");
const glibunix = @This();

const std = @import("std");
const compat = @import("compat");
const glib = @import("glib2");
/// A Unix pipe. The advantage of this type over `int[2]` is that it can
/// be closed automatically when it goes out of scope, using `g_auto(GUnixPipe)`,
/// on compilers that support that feature.
pub const Pipe = extern struct {
    /// A pair of file descriptors, each negative if closed or not yet opened.
    ///  The file descriptor with index `G_UNIX_PIPE_END_READ` is readable.
    ///  The file descriptor with index `G_UNIX_PIPE_END_WRITE` is writable.
    f_fds: [2]c_int,
};

/// Mnemonic constants for the ends of a Unix pipe.
pub const PipeEnd = enum(c_int) {
    read = 0,
    write = 1,
    _,
};

extern fn g_closefrom(p_lowfd: c_int) c_int;
pub const closefrom = g_closefrom;

extern fn g_unix_error_quark() glib.Quark;
pub const errorQuark = g_unix_error_quark;

extern fn g_unix_fd_add(p_fd: c_int, p_condition: glib.IOCondition, p_function: glib.UnixFDSourceFunc, p_user_data: ?*anyopaque) c_uint;
pub const fdAdd = g_unix_fd_add;

extern fn g_unix_fd_add_full(p_priority: c_int, p_fd: c_int, p_condition: glib.IOCondition, p_function: glib.UnixFDSourceFunc, p_user_data: ?*anyopaque, p_notify: ?glib.DestroyNotify) c_uint;
pub const fdAddFull = g_unix_fd_add_full;

extern fn g_unix_fd_source_new(p_fd: c_int, p_condition: glib.IOCondition) *glib.Source;
pub const fdSourceNew = g_unix_fd_source_new;

extern fn g_fdwalk_set_cloexec(p_lowfd: c_int) c_int;
pub const fdwalkSetCloexec = g_fdwalk_set_cloexec;

extern fn g_unix_get_passwd_entry(p_user_name: [*:0]const u8, p_error: ?*?*glib.Error) ?*anyopaque;
pub const getPasswdEntry = g_unix_get_passwd_entry;

extern fn g_unix_open_pipe(p_fds: *c_int, p_flags: c_int, p_error: ?*?*glib.Error) c_int;
pub const openPipe = g_unix_open_pipe;

extern fn g_unix_set_fd_nonblocking(p_fd: c_int, p_nonblock: c_int, p_error: ?*?*glib.Error) c_int;
pub const setFdNonblocking = g_unix_set_fd_nonblocking;

extern fn g_unix_signal_add(p_signum: c_int, p_handler: glib.SourceFunc, p_user_data: ?*anyopaque) c_uint;
pub const signalAdd = g_unix_signal_add;

extern fn g_unix_signal_add_full(p_priority: c_int, p_signum: c_int, p_handler: glib.SourceFunc, p_user_data: ?*anyopaque, p_notify: ?glib.DestroyNotify) c_uint;
pub const signalAddFull = g_unix_signal_add_full;

extern fn g_unix_signal_source_new(p_signum: c_int) *glib.Source;
pub const signalSourceNew = g_unix_signal_source_new;

/// The type of functions to be called when a UNIX fd watch source
/// triggers.
pub const FDSourceFunc = *const fn (p_fd: c_int, p_condition: glib.IOCondition, p_user_data: ?*anyopaque) callconv(.C) c_int;
