#ifndef ATL_ztGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,96,167,202,238,274,310,345,381,416,452,487,523,559,595,666,737,808,880,1023,1166,1308,1451,1594,1737,2022,2308,2879,3450,4021,4592,6876,9160
 * N : 25,96,167,202,238,274,310,345,381,416,452,487,523,559,595,666,737,808,880,1023,1166,1308,1451,1594,1737,2022,2308,2879,3450,4021,4592,6876,9160
 * NB : 1,1,9,11,33,36,43,55,59,59,63,63,64,66,67,67,71,77,79,82,83,82,91,91,95,96,99,108,179,180,195,480,480
 */
#define ATL_ztGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 131) (nb_) = 1; \
   else if ((n_) < 184) (nb_) = 9; \
   else if ((n_) < 220) (nb_) = 11; \
   else if ((n_) < 256) (nb_) = 33; \
   else if ((n_) < 292) (nb_) = 36; \
   else if ((n_) < 327) (nb_) = 43; \
   else if ((n_) < 363) (nb_) = 55; \
   else if ((n_) < 434) (nb_) = 59; \
   else if ((n_) < 505) (nb_) = 63; \
   else if ((n_) < 541) (nb_) = 64; \
   else if ((n_) < 577) (nb_) = 66; \
   else if ((n_) < 701) (nb_) = 67; \
   else if ((n_) < 772) (nb_) = 71; \
   else if ((n_) < 844) (nb_) = 77; \
   else if ((n_) < 951) (nb_) = 79; \
   else if ((n_) < 1094) (nb_) = 82; \
   else if ((n_) < 1237) (nb_) = 83; \
   else if ((n_) < 1379) (nb_) = 82; \
   else if ((n_) < 1665) (nb_) = 91; \
   else if ((n_) < 1879) (nb_) = 95; \
   else if ((n_) < 2165) (nb_) = 96; \
   else if ((n_) < 2593) (nb_) = 99; \
   else if ((n_) < 3164) (nb_) = 108; \
   else if ((n_) < 3735) (nb_) = 179; \
   else if ((n_) < 4306) (nb_) = 180; \
   else if ((n_) < 5734) (nb_) = 195; \
   else (nb_) = 480; \
}


#endif    /* end ifndef ATL_ztGetNB_geqrf */
