#ifndef ATL_ctGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,180,336,375,414,453,492,531,570,609,648,803,959,1115,1271,1426,1582,1738,1894,2050,2206,2362,2518,3765,5012,7506,10000
 * N : 25,180,336,375,414,453,492,531,570,609,648,803,959,1115,1271,1426,1582,1738,1894,2050,2206,2362,2518,3765,5012,7506,10000
 * NB : 1,1,11,35,39,42,43,43,44,44,51,51,53,54,59,60,61,61,63,63,64,66,67,67,131,147,384
 */
#define ATL_ctGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 258) (nb_) = 1; \
   else if ((n_) < 355) (nb_) = 11; \
   else if ((n_) < 394) (nb_) = 35; \
   else if ((n_) < 433) (nb_) = 39; \
   else if ((n_) < 472) (nb_) = 42; \
   else if ((n_) < 550) (nb_) = 43; \
   else if ((n_) < 628) (nb_) = 44; \
   else if ((n_) < 881) (nb_) = 51; \
   else if ((n_) < 1037) (nb_) = 53; \
   else if ((n_) < 1193) (nb_) = 54; \
   else if ((n_) < 1348) (nb_) = 59; \
   else if ((n_) < 1504) (nb_) = 60; \
   else if ((n_) < 1816) (nb_) = 61; \
   else if ((n_) < 2128) (nb_) = 63; \
   else if ((n_) < 2284) (nb_) = 64; \
   else if ((n_) < 2440) (nb_) = 66; \
   else if ((n_) < 4388) (nb_) = 67; \
   else if ((n_) < 6259) (nb_) = 131; \
   else if ((n_) < 8753) (nb_) = 147; \
   else (nb_) = 384; \
}


#endif    /* end ifndef ATL_ctGetNB_geqrf */
