/*  prefsdat.c: (c) 2002 sibn

    This file is part of GWiz.

    GWiz is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GWiz is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GWiz; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_ttf.h>
#include <fcntl.h>
#include <netinet/in.h>
#include "gwiz.h"
#include "prefsdat.h"
#include "uiloop.h"
#include "maploader.h"
#include "menus.h"

extern GwizApp gwiz;

void SetDefaultPrefs (void)
{
    gwiz.key.quit = 0;
    gwiz.key.fwd = SDLK_KP8;
    gwiz.key.bkwd = SDLK_KP5;
    gwiz.key.lft = SDLK_KP7;
    gwiz.key.rgt = SDLK_KP9;
    gwiz.key.fta = SDLK_KP2;
    gwiz.key.slft = SDLK_KP4;
    gwiz.key.srgt = SDLK_KP6;
    gwiz.key.act = SDLK_KP_ENTER;
    gwiz.key.cancel = SDLK_KP0;
    gwiz.font.ptsize = 16;
    gwiz.font.aa = 1;
    gwiz.vidmode = (SDL_HWSURFACE | SDL_DOUBLEBUF);
    gwiz.bpp = 32;
    /* Who says there's no accounting for byte order? */
#if SDL_BYTEORDER == SDL_BIG_ENDIAN
    gwiz.rmask = 0xff000000;
    gwiz.gmask = 0x00ff0000;
    gwiz.bmask = 0x0000ff00;
    gwiz.amask = 0x000000ff;
    gwiz.nmask = 0x00000000;
#else
    gwiz.rmask = 0x000000ff;
    gwiz.gmask = 0x0000ff00;
    gwiz.bmask = 0x00ff0000;
    gwiz.amask = 0xff000000;
    gwiz.nmask = 0x00000000; /* "No alpha" */
#endif
    
    gwiz.font.ptsize = 16; 
    gwiz.font.aa = 1;
    gwiz.udata.home = getenv("HOME");
    gwiz.udata.gwiz = MakePath(gwiz.udata.home, "/.gwiz");
    gwiz.udata.cfg = MakePath(gwiz.udata.gwiz, "/cfg06");
    gwiz.udata.party = MakePath(gwiz.udata.gwiz, "/party08");
    gwiz.udata.post = MakePath(gwiz.udata.gwiz, "/tradingpost");
    gwiz.udata.log = MakePath (gwiz.udata.gwiz, "/log");
    gwiz.udata.monsters = MakePath (PKGDATADIR, "/monsters");
    gwiz.udata.items = MakePath (PKGDATADIR, "/items");
    gwiz.vidmode = (SDL_HWSURFACE | SDL_DOUBLEBUF);
    gwiz.bpp = 32;
    gwiz.bgc = 0x00000000;
    gwiz.fgc = 0xffffffff;
    gwiz.logging = 1;
    gwiz.freshlog = 0;

    gwiz.joy.dev = NULL;
    gwiz.joy.enabled = TRUE;
    gwiz.joy.whichdev = -1;
    gwiz.joy.fwd = -16384;
    gwiz.joy.bkwd = 0;
    gwiz.joy.lft = -16384;
    gwiz.joy.rgt = 16384;
    gwiz.joy.fta = 16384;
    gwiz.joy.slft = 0;
    gwiz.joy.srgt = 0;
    gwiz.joy.act = 0;
    gwiz.joy.cancel = 0;
    gwiz.battle = FALSE;
    gwiz.ffi = TRUE;
    
    SetDefaultShopStocks ();
}

void CheckPrefs (void)
{
    int fd;
    
    fd = open (gwiz.udata.gwiz, O_RDONLY, 0644);
    if (fd < 0)
	CreatePrefs(0);
    else
	close (fd);
    
    fd = open (gwiz.udata.cfg, O_RDONLY, 0644);
    if (fd < 0)
	CreatePrefs(1);
    else
	close (fd);
}

void CreatePrefs (int num)
{
    switch (num)
	{
	case 0:
	    if (mkdir(gwiz.udata.gwiz, 0755) != 0)
		BailCall ("prefsdat.c: Unable to create prefs dir", 
			  gwiz.udata.gwiz);
	    break;
	case 1:
	    /* Much cleaner than "the old way" */
	    SavePrefs();
	}
}

int LoadPrefs (void)
{
    FILE *cfg;
    int i;
    
    SetDefaultPrefs();
    CheckPrefs();
    
    cfg = fopen (gwiz.udata.cfg, "rb");
    if (cfg == NULL)
	BailCall ("prefsdat.c: unable to read prefs file: ",
		  gwiz.udata.cfg);
    fread (&gwiz.key, sizeof(GwizKeys), 1, cfg);
    fread (&gwiz.font.ptsize, sizeof(int), 1, cfg);
    fread (&gwiz.font.aa, sizeof(int), 1, cfg);
    fread (&gwiz.vidmode, sizeof(Uint32), 1, cfg);
    fread (&gwiz.bpp, sizeof(int), 1, cfg);
    fread (&gwiz.logging, sizeof(int), 1, cfg);
    for (i = 0; i < 256; i++)
	fread (&gwiz.shopstocks[i], sizeof(int), 1, cfg);
    fclose (cfg);
    
    FlipPrefsToHost(); /* The prefs are saved network-endian */
    
    return (0);
}

void SavePrefs (void)
{
    FILE *cfg;
    int i;
    
    cfg = fopen (gwiz.udata.cfg, "wb"); /* write only */
    if (cfg == NULL)
	BailCall ("prefsdat.c: Unable to open prefs file: ",
		  gwiz.udata.cfg);
    
    FlipPrefsToNetwork(); /* Prepare to write endian-independant */
    
    fwrite (&gwiz.key, sizeof(GwizKeys), 1, cfg);
    fwrite (&gwiz.font.ptsize, sizeof(int), 1, cfg);
    fwrite (&gwiz.font.aa, sizeof(int), 1, cfg);
    fwrite (&gwiz.vidmode, sizeof(Uint32), 1, cfg);
    fwrite (&gwiz.bpp, sizeof(int), 1, cfg);
    fwrite (&gwiz.logging, sizeof(int), 1, cfg);
    for (i = 0; i < 256; i++)
	fwrite (&gwiz.shopstocks[i], sizeof(int), 1, cfg);
    fclose (cfg);
    
    FlipPrefsToHost(); /* Flip the byte-order back for future use */
}

void FlipPrefsToNetwork(void)
{
    int i;
    
    gwiz.key.quit = htonl(gwiz.key.quit);
    gwiz.key.fwd  = htonl(gwiz.key.fwd);
    gwiz.key.bkwd = htonl(gwiz.key.bkwd);
    gwiz.key.lft  = htonl(gwiz.key.lft);
    gwiz.key.rgt  = htonl(gwiz.key.rgt);
    gwiz.key.slft = htonl(gwiz.key.slft);
    gwiz.key.srgt = htonl(gwiz.key.srgt);
    gwiz.key.fta  = htonl(gwiz.key.fta);
    gwiz.key.act  = htonl(gwiz.key.act);
    gwiz.key.cancel =  htonl(gwiz.key.cancel);
    gwiz.font.ptsize = htonl(gwiz.font.ptsize);
    gwiz.font.aa = htonl (gwiz.font.aa);
    gwiz.vidmode = htonl (gwiz.vidmode);
    gwiz.bpp = htonl (gwiz.bpp);
    gwiz.logging = htonl (gwiz.logging);
    
    for (i = 0; i < 256; i++)
	gwiz.shopstocks[i] = htonl (gwiz.shopstocks[i]);
}

void FlipPrefsToHost(void)
{
    int i;
    
    gwiz.key.quit = ntohl(gwiz.key.quit);
    gwiz.key.fwd  = ntohl(gwiz.key.fwd);
    gwiz.key.bkwd = ntohl(gwiz.key.bkwd);
    gwiz.key.lft  = ntohl(gwiz.key.lft);
    gwiz.key.rgt  = ntohl(gwiz.key.rgt);
    gwiz.key.slft = ntohl(gwiz.key.slft);
    gwiz.key.srgt = ntohl(gwiz.key.srgt);
    gwiz.key.fta  = ntohl(gwiz.key.fta);
    gwiz.key.act  = ntohl(gwiz.key.act);
    gwiz.key.cancel =  ntohl(gwiz.key.cancel);
    gwiz.font.ptsize = ntohl(gwiz.font.ptsize);
    gwiz.font.aa = ntohl (gwiz.font.aa);
    gwiz.vidmode = ntohl (gwiz.vidmode);
    gwiz.bpp = ntohl (gwiz.bpp);
    gwiz.logging = ntohl (gwiz.logging);
    
    for (i = 0; i < 256; i++)
	gwiz.shopstocks[i] = ntohl (gwiz.shopstocks[i]);
}

void SetDefaultShopStocks (void)
{
    int i;
    
    /* this introduces an off-by-one error.  Cannot have more than 255
       items; shouldn't be a problem. */
    for (i = 1; i < 256; i++)
	gwiz.shopstocks[i] = 0;
    
    /* Zero = not available, -1 = always available */
    gwiz.shopstocks[1] = -1;
    gwiz.shopstocks[2] = -1;
    gwiz.shopstocks[3] = -1;
    gwiz.shopstocks[4] = -1;
    gwiz.shopstocks[5] = -1;
    gwiz.shopstocks[6] = -1;
}

