/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.datacontrol;

import pcgen.cdom.content.ContentDefinition;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SelectableToken
extends AbstractNonEmptyToken<ContentDefinition>
implements CDOMPrimaryToken<ContentDefinition> {
    public String getTokenName() {
        return "SELECTABLE";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, ContentDefinition factDef, String value) {
        boolean set;
        char firstChar = value.charAt(0);
        if (firstChar == 'y' || firstChar == 'Y') {
            if (value.length() > 1 && !value.equalsIgnoreCase("YES")) {
                return new ParseResult.Fail("You should use 'YES' as the " + this.getTokenName() + ": " + value, context);
            }
            set = true;
        } else {
            if (firstChar != 'N' && firstChar != 'n') {
                return new ParseResult.Fail("You should use 'YES' or 'NO' as the " + this.getTokenName() + ": " + value, context);
            }
            if (value.length() > 1 && !value.equalsIgnoreCase("NO")) {
                return new ParseResult.Fail("You should use 'YES' or 'NO' as the " + this.getTokenName() + ": " + value, context);
            }
            set = false;
        }
        factDef.setSelectable(set);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, ContentDefinition factDef) {
        Boolean selectable = factDef.getSelectable();
        if (selectable == null) {
            return null;
        }
        return new String[]{selectable != false ? "YES" : "NO"};
    }

    public Class<ContentDefinition> getTokenClass() {
        return ContentDefinition.class;
    }
}

