/*
 * Decompiled with CFR 0.152.
 */
package plugin.doomsdaybook;

import gmgen.GMGenSystemView;
import gmgen.pluginmgr.messages.AddMenuItemToGMGenToolsMenuMessage;
import gmgen.pluginmgr.messages.RequestAddTabToGMGenMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import pcgen.core.SettingsHandler;
import pcgen.gui2.doomsdaybook.NameGenPanel;
import pcgen.gui2.tools.Utility;
import pcgen.pluginmgr.InteractivePlugin;
import pcgen.pluginmgr.PCGenMessage;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.messages.FocusOrStateChangeOccurredMessage;
import pcgen.system.LanguageBundle;

public class RandomNamePlugin
implements InteractivePlugin {
    public static final String LOG_NAME = "Random_Name_Generator";
    private JMenuItem nameToolsItem = new JMenuItem();
    private NameGenPanel theView;
    private static final String NAME = "Random Names";
    private static final String IN_NAME = "in_plugin_randomname_name";
    private static final String IN_NAME_MN = "in_mn_plugin_randomname_name";
    private String version = "01.00.99.01.00";
    private PCGenMessageHandler messageHandler;

    public void start(PCGenMessageHandler mh) {
        this.messageHandler = mh;
        this.theView = new NameGenPanel(this.getDataDirectory());
        this.messageHandler.handleMessage((PCGenMessage)new RequestAddTabToGMGenMessage((Object)this, this.getLocalizedName(), this.getView()));
        this.initMenus();
    }

    public void stop() {
        this.messageHandler = null;
    }

    public int getPriority() {
        return SettingsHandler.getGMGenOption((String)"Random_Name_Generator.LoadOrder", (int)80);
    }

    public String getPluginName() {
        return NAME;
    }

    private String getLocalizedName() {
        return LanguageBundle.getString((String)IN_NAME);
    }

    public Component getView() {
        return this.theView;
    }

    public void handleMessage(PCGenMessage message) {
        if (message instanceof FocusOrStateChangeOccurredMessage) {
            if (this.isActive()) {
                this.nameToolsItem.setEnabled(false);
            } else {
                this.nameToolsItem.setEnabled(true);
            }
        }
    }

    public boolean isActive() {
        JTabbedPane tp = Utility.getTabbedPaneFor((Component)this.theView);
        return tp != null && JOptionPane.getFrameForComponent(tp).isFocused() && tp.getSelectedComponent().equals(this.theView);
    }

    public void initMenus() {
        this.nameToolsItem.setMnemonic(LanguageBundle.getMnemonic((String)IN_NAME_MN));
        this.nameToolsItem.setText(this.getLocalizedName());
        this.nameToolsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomNamePlugin.this.toolMenuItem(evt);
            }
        });
        this.messageHandler.handleMessage((PCGenMessage)new AddMenuItemToGMGenToolsMenuMessage((Object)this, this.nameToolsItem));
    }

    public void toolMenuItem(ActionEvent evt) {
        JTabbedPane tp = GMGenSystemView.getTabPane();
        for (int i = 0; i < tp.getTabCount(); ++i) {
            if (!(tp.getComponentAt(i) instanceof NameGenPanel)) continue;
            tp.setSelectedIndex(i);
        }
    }

    public File getDataDirectory() {
        File dataDir = new File(SettingsHandler.getGmgenPluginDir(), this.getPluginName());
        return dataDir;
    }
}

