/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.choose;

import java.util.ArrayList;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.Chooser;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.base.SpellLevelChooseInformation;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.SpellLevel;
import pcgen.cdom.helper.SpellLevelInfo;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SpellLevelToken
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
Chooser<SpellLevel> {
    @Override
    public String getParentToken() {
        return "CHOOSE";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    public ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        String title;
        String activeValue;
        int pipeLoc = value.lastIndexOf(124);
        if (pipeLoc == -1) {
            activeValue = value;
            title = this.getDefaultTitle();
        } else {
            String titleString = value.substring(pipeLoc + 1);
            if (titleString.startsWith("TITLE=")) {
                title = titleString.substring(6);
                if (title.startsWith("\"")) {
                    title = title.substring(1, title.length() - 1);
                }
                activeValue = value.substring(0, pipeLoc);
            } else {
                activeValue = value;
                title = this.getDefaultTitle();
            }
        }
        pipeLoc = value.indexOf(124);
        ParsingSeparator sep = new ParsingSeparator(activeValue, '|');
        if (!sep.hasNext()) {
            return new ParseResult.Fail("Found no arguments in " + this.getFullName() + ": " + value, context);
        }
        ArrayList<SpellLevelInfo> sliList = new ArrayList<SpellLevelInfo>();
        while (sep.hasNext()) {
            String token = sep.next();
            PrimitiveCollection<PCClass> pcf = context.getPrimitiveChoiceFilter(context.getReferenceContext().getManufacturer(PCClass.class), token);
            if (!sep.hasNext()) {
                return new ParseResult.Fail("Expected minimum level argument after " + token + " in " + this.getFullName() + ": " + value, context);
            }
            String minLevelString = sep.next();
            Formula minLevel = FormulaFactory.getFormulaFor(minLevelString);
            if (!sep.hasNext()) {
                return new ParseResult.Fail("Expected maximum level argument after " + minLevelString + " in " + this.getFullName() + ": " + value, context);
            }
            String maxLevelString = sep.next();
            Formula maxLevel = FormulaFactory.getFormulaFor(maxLevelString);
            if (!maxLevel.isValid()) {
                return new ParseResult.Fail("Max Level Formula in " + this.getTokenName() + " was not valid: " + maxLevel.toString(), context);
            }
            SpellLevelInfo sli = new SpellLevelInfo(pcf, minLevel, maxLevel);
            sliList.add(sli);
        }
        SpellLevelChooseInformation tc = new SpellLevelChooseInformation(this.getTokenName(), sliList);
        tc.setTitle(title);
        tc.setChoiceActor(this);
        context.getObjectContext().put(obj, ObjectKey.CHOOSE_INFO, tc);
        return ParseResult.SUCCESS;
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject cdo) {
        ChooseInformation<?> tc = context.getObjectContext().getObject(cdo, ObjectKey.CHOOSE_INFO);
        if (tc == null) {
            return null;
        }
        if (!tc.getName().equals(this.getTokenName())) {
            return null;
        }
        if (!tc.getGroupingState().isValid()) {
            context.addWriteMessage("Invalid combination of objects was used in: " + this.getParentToken() + ":" + this.getTokenName());
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tc.getLSTformat());
        String title = tc.getTitle();
        if (!title.equals(this.getDefaultTitle())) {
            sb.append("|TITLE=");
            sb.append(title);
        }
        return new String[]{sb.toString()};
    }

    @Override
    public void applyChoice(ChooseDriver owner, SpellLevel st, PlayerCharacter pc) {
        this.restoreChoice(pc, owner, st);
    }

    @Override
    public void removeChoice(PlayerCharacter pc, ChooseDriver owner, SpellLevel choice) {
        pc.removeAssoc(owner, this.getListKey(), choice);
        List<ChooseSelectionActor<?>> actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor<?> ca : actors) {
                ca.removeChoice(owner, choice, pc);
            }
        }
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, ChooseDriver owner, SpellLevel choice) {
        pc.addAssoc(owner, this.getListKey(), choice);
        List<ChooseSelectionActor<?>> actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor<?> ca : actors) {
                ca.applyChoice(owner, choice, pc);
            }
        }
    }

    @Override
    public List<SpellLevel> getCurrentlySelected(ChooseDriver owner, PlayerCharacter pc) {
        return pc.getAssocList(owner, this.getListKey());
    }

    @Override
    public boolean allow(SpellLevel choice, PlayerCharacter pc, boolean allowStack) {
        return true;
    }

    @Override
    public String getTokenName() {
        return "SPELLLEVEL";
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    protected String getDefaultTitle() {
        return "Choose Spell Level";
    }

    protected AssociationListKey<SpellLevel> getListKey() {
        return AssociationListKey.getKeyFor(SpellLevel.class, "CHOOSE*SPELLLEVEL");
    }

    @Override
    public SpellLevel decodeChoice(LoadContext context, String s) {
        return SpellLevel.decodeChoice(s);
    }

    @Override
    public String encodeChoice(SpellLevel choice) {
        return choice.encodeChoice();
    }
}

