/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Kit;
import pcgen.core.kit.BaseKit;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.CDOMSubLineLoader;
import pcgen.util.Logging;

public class CDOMKitLoader {
    private final Map<String, CDOMSubLineLoader<? extends BaseKit>> loadMap = new HashMap<String, CDOMSubLineLoader<? extends BaseKit>>();
    private final Class<Kit> targetClass = Kit.class;

    public void addLineLoader(CDOMSubLineLoader<? extends BaseKit> loader) {
        this.loadMap.put(loader.getPrefix(), loader);
    }

    public boolean parseSubLine(LoadContext context, Kit obj, String val, URI source) {
        int sepLoc = val.indexOf(9);
        String firstToken = sepLoc == -1 ? val : val.substring(0, sepLoc);
        int colonLoc = firstToken.indexOf(58);
        if (colonLoc == -1) {
            Logging.addParseMessage(Logging.LST_ERROR, "Unsure what to do with line without a colon in first token: " + val + " in file: " + source);
            return false;
        }
        String prefix = firstToken.substring(0, colonLoc);
        CDOMSubLineLoader<? extends BaseKit> loader = this.loadMap.get(prefix);
        if (loader == null) {
            Logging.addParseMessage(Logging.LST_ERROR, "Unsure what to do with line with prefix: " + prefix + ".  Line was: " + val + " in file: " + source);
            return false;
        }
        try {
            if (!this.subParse(context, obj, loader, val)) {
                return false;
            }
        }
        catch (PersistenceLayerException ple) {
            Logging.errorPrint("Exception in Load: ", ple);
            return false;
        }
        return true;
    }

    private <CC extends BaseKit> boolean subParse(LoadContext context, Kit kit, CDOMSubLineLoader<CC> loader, String line) throws PersistenceLayerException {
        BaseKit obj = (BaseKit)loader.getCDOMObject();
        context.getObjectContext().addToList(kit, ListKey.KIT_TASKS, obj);
        return loader.parseLine(context, obj, line);
    }

    protected Kit getCDOMObject(LoadContext context, String name) {
        Kit obj = context.getReferenceContext().silentlyGetConstructedCDOMObject(this.targetClass, name);
        if (obj == null) {
            obj = context.getReferenceContext().constructCDOMObject(this.targetClass, name);
        }
        return obj;
    }

    public Class<Kit> getTargetClass() {
        return this.targetClass;
    }
}

