/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;

public abstract class AbstractListMenu<E>
extends JMenu
implements ListListener<E> {
    private ListFacade<E> listModel;
    private int oldSize = 0;
    private int offset = 0;

    public AbstractListMenu(Action action) {
        this(action, null);
    }

    public AbstractListMenu(Action action, ListFacade<E> listModel) {
        super(action);
        this.setListModel(listModel);
    }

    @Override
    public void elementAdded(ListEvent<E> e) {
        this.rebuildListMenu();
    }

    @Override
    public void elementRemoved(ListEvent<E> e) {
        this.rebuildListMenu();
    }

    @Override
    public void elementsChanged(ListEvent<E> e) {
        this.rebuildListMenu();
    }

    @Override
    public void elementModified(ListEvent<E> e) {
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        Dimension size = this.getSize();
        double oneRowUpHeight = size.getHeight() * -1.0 - 5.0;
        return new Point((int)size.getWidth(), (int)oneRowUpHeight);
    }

    private void rebuildListMenu() {
        int i;
        for (i = 0; i < this.oldSize; ++i) {
            this.remove(this.offset);
        }
        this.oldSize = this.listModel.getSize();
        for (i = 0; i < this.oldSize; ++i) {
            this.add((Component)this.createMenuItem(this.listModel.getElementAt(i), i), i + this.offset);
        }
        this.checkEnabled();
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setListModel(ListFacade<E> listModel) {
        int x;
        ListFacade<E> oldModel = this.listModel;
        if (oldModel != null) {
            oldModel.removeListListener(this);
            for (x = 0; x < this.oldSize; ++x) {
                this.remove(this.offset);
            }
        }
        this.listModel = listModel;
        if (listModel != null) {
            this.oldSize = listModel.getSize();
            for (x = 0; x < this.oldSize; ++x) {
                this.add((Component)this.createMenuItem(listModel.getElementAt(x), x), x + this.offset);
            }
            listModel.addListListener(this);
        }
        this.checkEnabled();
    }

    protected abstract JMenuItem createMenuItem(E var1, int var2);

    protected void checkEnabled() {
        this.setEnabled(this.getMenuComponentCount() != 0);
    }

    protected static class CheckBoxMenuItem
    extends JCheckBoxMenuItem {
        private final Object item;

        public CheckBoxMenuItem(Object item, boolean selected, ItemListener listener) {
            this.item = item;
            this.setSelected(selected);
            this.addItemListener(listener);
        }

        @Override
        public String getText() {
            return this.item.toString();
        }

        @Override
        public Object[] getSelectedObjects() {
            return new Object[]{this.item};
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            Dimension size = this.getSize();
            double halfheight = size.getHeight() / 2.0;
            return new Point((int)size.getWidth(), (int)halfheight);
        }
    }
}

