/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.ability;

import javax.swing.JTable;
import pcgen.facade.core.AbilityCategoryFacade;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ChangeEvent;
import pcgen.facade.util.event.ChangeListener;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilteredListFacadeTableModel;

public class CategoryTableModel
extends FilteredListFacadeTableModel<AbilityCategoryFacade>
implements ChangeListener {
    boolean installed = false;
    private final JTable categoryTable;

    public CategoryTableModel(CharacterFacade character, ListFacade<AbilityCategoryFacade> categories, Filter<CharacterFacade, AbilityCategoryFacade> filter, JTable theCategoryTable) {
        super(character);
        this.categoryTable = theCategoryTable;
        this.setDelegate(categories);
        this.setFilter(filter);
    }

    public AbilityCategoryFacade getCategory(int index) {
        return (AbilityCategoryFacade)this.sortedList.getElementAt(index);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            return ((AbilityCategoryFacade)this.sortedList.getElementAt(rowIndex)).allowPoolMod();
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.character.setRemainingSelection((AbilityCategoryFacade)this.sortedList.getElementAt(rowIndex), (Integer)aValue);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Category";
            }
            case 1: {
                return "Total";
            }
            case 2: {
                return "Remaining";
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Object.class;
        }
        return Integer.class;
    }

    @Override
    protected Object getValueAt(AbilityCategoryFacade category, int column) {
        switch (column) {
            case 0: {
                return category;
            }
            case 1: {
                return this.character.getTotalSelections(category);
            }
            case 2: {
                return this.character.getRemainingSelections(category);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void ItemChanged(ChangeEvent event) {
        int i;
        int selectedRow;
        AbilityCategoryFacade facade = null;
        if (this.installed && (selectedRow = this.categoryTable.getSelectedRow()) >= 0 && selectedRow < this.sortedList.getSize()) {
            facade = (AbilityCategoryFacade)this.sortedList.getElementAt(selectedRow);
        }
        Object data = event.getSource();
        this.refilter();
        for (i = 0; i < this.getRowCount(); ++i) {
            AbilityCategoryFacade rowCat = this.getCategory(i);
            if (rowCat != data) continue;
            this.fireTableRowsUpdated(i, i);
        }
        if (facade != null) {
            for (i = 0; i < this.sortedList.getSize(); ++i) {
                if (facade != this.sortedList.getElementAt(i)) continue;
                this.categoryTable.getSelectionModel().setSelectionInterval(i, i);
                break;
            }
        }
    }

    public void install() {
        this.character.addAbilityCatSelectionListener(this);
        this.installed = true;
    }

    public void uninstall() {
        this.installed = false;
        this.character.removeAbilityCatSelectionListener(this);
    }
}

