/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import org.apache.commons.lang.StringUtils;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.prereq.PrerequisiteTestFactory;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class PreMult
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    @Override
    public int passes(Prerequisite prereq, PlayerCharacter character, CDOMObject source) throws PrerequisiteException {
        int runningTotal = 0;
        int targetNumber = Integer.parseInt(prereq.getOperand());
        for (Prerequisite element : prereq.getPrerequisites()) {
            PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
            PrerequisiteTest test = factory.getTest(element.getKind());
            if (test != null) {
                runningTotal += test.passes(element, character, source);
                continue;
            }
            Logging.errorPrintLocalised("PreMult.cannot_find_subtest", element.getKind());
        }
        runningTotal = prereq.getOperator().compare(runningTotal, targetNumber);
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String kindHandled() {
        return "MULT";
    }

    @Override
    public int passes(Prerequisite prereq, Equipment equipment, PlayerCharacter aPC) throws PrerequisiteException {
        int runningTotal = 0;
        int targetNumber = Integer.parseInt(prereq.getOperand());
        for (Prerequisite element : prereq.getPrerequisites()) {
            PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
            PrerequisiteTest test = factory.getTest(element.getKind());
            runningTotal += test.passes(element, equipment, aPC);
        }
        runningTotal = prereq.getOperator().compare(runningTotal, targetNumber);
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String toHtmlString(Prerequisite prereq) {
        PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
        StringBuilder str = new StringBuilder(250);
        String delimiter = "";
        for (Prerequisite element : prereq.getPrerequisites()) {
            PrerequisiteTest test = factory.getTest(element.getKind());
            if (test == null) {
                Logging.errorPrintLocalised("PreMult.cannot_find_subformatter", element.getKind());
                continue;
            }
            str.append(delimiter);
            if (test instanceof PreMult && !delimiter.equals("")) {
                str.append("##BR##");
            }
            str.append(test.toHtmlString(element));
            delimiter = LanguageBundle.getString("PreMult.html_delimiter");
        }
        int numRequired = -1;
        if (StringUtils.isNumeric(prereq.getOperand())) {
            numRequired = Integer.parseInt(prereq.getOperand());
        }
        if ((prereq.getOperator() == PrerequisiteOperator.GTEQ || prereq.getOperator() == PrerequisiteOperator.GT || prereq.getOperator() == PrerequisiteOperator.EQ) && numRequired == prereq.getPrerequisites().size()) {
            return LanguageBundle.getFormattedString("PreMult.toHtmlAllOf", str.toString());
        }
        if ((prereq.getOperator() == PrerequisiteOperator.GTEQ || prereq.getOperator() == PrerequisiteOperator.EQ) && numRequired == 1) {
            return LanguageBundle.getFormattedString("PreMult.toHtmlEither", str.toString());
        }
        if (prereq.getOperator() == PrerequisiteOperator.LT && numRequired == 1 || (prereq.getOperator() == PrerequisiteOperator.EQ || prereq.getOperator() == PrerequisiteOperator.LTEQ) && numRequired == 0) {
            return LanguageBundle.getFormattedString("PreMult.toHtmlNone", str.toString());
        }
        return LanguageBundle.getFormattedString("PreMult.toHtml", prereq.getOperator().toDisplayString(), prereq.getOperand(), str.toString());
    }
}

