/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.chooser.AbilityChooseController;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.SkillChooseController;

public class ChooserUtilities {
    public static final boolean modChoices(ChooseDriver aPObject, List availableList, List selectedList, PlayerCharacter aPC, boolean addIt, AbilityCategory category) {
        availableList.clear();
        selectedList.clear();
        ArrayList<String> reservedList = new ArrayList<String>();
        ChoiceManagerList aMan = ChooserUtilities.getConfiguredController(aPObject, aPC, category, reservedList);
        if (aMan == null) {
            return false;
        }
        aMan.getChoices(aPC, availableList, selectedList);
        if (availableList.size() > 0 || selectedList.size() > 0) {
            if (addIt) {
                List newSelections = aMan.doChooser(aPC, availableList, selectedList, reservedList);
                return aMan.applyChoices(aPC, newSelections);
            }
            aMan.doChooserRemove(aPC, availableList, selectedList, reservedList);
            return true;
        }
        return false;
    }

    public static <T> ChoiceManagerList<T> getConfiguredController(ChooseDriver aPObject, PlayerCharacter aPC, AbilityCategory category, List<String> reservedList) {
        ChoiceManagerList aMan = ChooserUtilities.getChoiceManager(aPObject, aPC);
        if (aMan == null) {
            return null;
        }
        if (aPObject instanceof CNAbility) {
            CNAbility driver = (CNAbility)aPObject;
            Ability a = driver.getAbility();
            AbilityCategory cat = category == null ? SettingsHandler.getGame().getAbilityCategory(a.getCategory()) : category;
            aMan.setController(new AbilityChooseController(a, cat, aPC, aMan));
            List<CNAbility> abilities = aPC.getMatchingCNAbilities(a);
            for (CNAbility cna : abilities) {
                reservedList.addAll(aPC.getAssociationList(cna));
            }
        } else if (aPObject instanceof Skill) {
            Skill s = (Skill)aPObject;
            aMan.setController(new SkillChooseController(s, aPC));
        }
        return aMan;
    }

    private static void modifyAvailChoicesForAbilityCategory(List availableList, AbilityCategory category, Ability ability) {
        AbilityCategory cat = category == null ? SettingsHandler.getGame().getAbilityCategory(ability.getCategory()) : category;
        if (!cat.hasDirectReferences()) {
            return;
        }
        HashSet<String> allowedSet = new HashSet<String>();
        for (CDOMSingleRef<Ability> ref : cat.getAbilityRefs()) {
            if (!ref.contains(ability)) continue;
            ArrayList<String> choices = new ArrayList<String>();
            AbilityUtilities.getUndecoratedName(ref.getLSTformat(false), choices);
            allowedSet.addAll(choices);
        }
        if (allowedSet.isEmpty()) {
            return;
        }
        Iterator iterator = availableList.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            String key = obj instanceof CDOMObject ? ((CDOMObject)obj).getKeyName() : obj.toString();
            if (allowedSet.contains(key)) continue;
            iterator.remove();
        }
    }

    public static ChoiceManagerList getChoiceManager(ChooseDriver aPObject, PlayerCharacter aPC) {
        ChooseInformation<?> chooseInfo = aPObject.getChooseInfo();
        if (chooseInfo != null) {
            Formula selectionsPerUnitCost = aPObject.getSelectFormula();
            int cost = selectionsPerUnitCost.resolve(aPC, "").intValue();
            return chooseInfo.getChoiceManager(aPObject, cost);
        }
        return null;
    }
}

