/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.RaceSubType;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.core.PCTemplate;
import pcgen.core.Race;

public class RacialSubTypesFacet {
    private TemplateFacet templateFacet;
    private RaceFacet raceFacet;

    public Collection<RaceSubType> getRacialSubTypes(CharID id) {
        Set templates;
        ArrayList<RaceSubType> racialSubTypes = new ArrayList<RaceSubType>();
        Race race = (Race)((AbstractItemFacet)this.raceFacet).get(id);
        if (race != null) {
            for (RaceSubType st : race.getSafeListFor(ListKey.RACESUBTYPE)) {
                racialSubTypes.add(st);
            }
        }
        if (!(templates = this.templateFacet.getSet(id)).isEmpty()) {
            ArrayList<RaceSubType> added = new ArrayList<RaceSubType>();
            ArrayList<RaceSubType> removed = new ArrayList<RaceSubType>();
            for (PCTemplate aTemplate : templates) {
                added.addAll(aTemplate.getSafeListFor(ListKey.RACESUBTYPE));
                removed.addAll(aTemplate.getSafeListFor(ListKey.REMOVED_RACESUBTYPE));
            }
            for (RaceSubType st : added) {
                racialSubTypes.add(st);
            }
            for (RaceSubType st : removed) {
                racialSubTypes.remove(st);
            }
        }
        return Collections.unmodifiableList(racialSubTypes);
    }

    public boolean contains(CharID id, RaceSubType subType) {
        return this.getRacialSubTypes(id).contains(subType);
    }

    public int getCount(CharID id) {
        return this.getRacialSubTypes(id).size();
    }

    public void setTemplateFacet(TemplateFacet templateFacet) {
        this.templateFacet = templateFacet;
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }
}

