/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Constants;
import pcgen.cdom.enumeration.FactKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Ability;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellInfo;
import pcgen.core.spell.Spell;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Delta;

public class SpellMemToken
extends Token {
    public static final String TOKENNAME = "SPELLMEM";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter aPC, ExportHandler eh) {
        PObject aObject;
        StringBuilder retValue = new StringBuilder();
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        int classNum = Integer.parseInt(aTok.nextToken());
        int bookNum = Integer.parseInt(aTok.nextToken());
        int spellLevel = Integer.parseInt(aTok.nextToken());
        int spellNumber = Integer.parseInt(aTok.nextToken());
        boolean found = false;
        String aLabel = "NAME";
        if (aTok.hasMoreTokens()) {
            aLabel = aTok.nextToken();
        }
        String altLabel = "";
        if (aTok.hasMoreTokens()) {
            altLabel = aTok.nextToken();
        }
        if ((aObject = aPC.getSpellClassAtIndex(classNum)) == null && eh != null && eh.getExistsOnly() && classNum != -1) {
            eh.setNoMoreItems(true);
        }
        String bookName = Globals.getDefaultSpellBook();
        if (bookNum > 0) {
            bookName = (String)aPC.getDisplay().getSpellBookNames().get(bookNum);
        }
        if (aObject != null || classNum == -1) {
            if (classNum == -1) {
                bookName = Globals.getDefaultSpellBook();
            }
            CharacterSpell selectedCSpell = null;
            if (!"".equals(bookName)) {
                Spell aSpell = null;
                if (classNum == -1) {
                    ArrayList<CharacterSpell> charSpellList = new ArrayList<CharacterSpell>();
                    for (PCClass pcClass : aPC.getDisplay().getClassSet()) {
                        List aList = aPC.getCharacterSpells((CDOMObject)pcClass, null, bookName, spellLevel);
                        for (CharacterSpell cs : aList) {
                            if (charSpellList.contains(cs)) continue;
                            charSpellList.add(cs);
                        }
                    }
                    Collections.sort(charSpellList);
                    if (spellNumber < charSpellList.size()) {
                        selectedCSpell = (CharacterSpell)charSpellList.get(spellNumber);
                        aSpell = selectedCSpell.getSpell();
                        found = true;
                    }
                } else if (aObject != null) {
                    List charSpells = aPC.getCharacterSpells((CDOMObject)aObject, null, bookName, spellLevel);
                    if (spellNumber < charSpells.size()) {
                        selectedCSpell = (CharacterSpell)charSpells.get(spellNumber);
                        aSpell = selectedCSpell.getSpell();
                        found = true;
                    }
                } else if (eh != null && eh.getInLabel() && eh.getCheckBefore()) {
                    eh.setCanWrite(false);
                }
                if (selectedCSpell == null) {
                    if (eh != null && eh.getExistsOnly()) {
                        eh.setNoMoreItems(true);
                    }
                    return retValue.toString();
                }
                SpellInfo si = selectedCSpell.getSpellInfoFor(bookName, spellLevel);
                if (found && aSpell != null && si != null) {
                    String sString;
                    PCClass aClass;
                    String aTemp;
                    String mString;
                    if ("NAME".equals(aLabel) || "OUTPUTNAME".equals(aLabel)) {
                        retValue.append(OutputNameFormatting.getOutputName((CDOMObject)aSpell) + si.toString());
                    } else if ("BASENAME".equals(aLabel)) {
                        retValue.append(OutputNameFormatting.getOutputName((CDOMObject)aSpell));
                    } else if ("APPLIEDNAME".equals(aLabel)) {
                        retValue.append(this.getAppliedName(si));
                    } else if ("PPCOST".equals(aLabel)) {
                        if (si.getActualPPCost() != -1) {
                            retValue.append(si.getActualPPCost());
                        }
                    } else if ("TIMES".equals(aLabel)) {
                        if (si.getTimes() == -1) {
                            retValue.append("At Will");
                        } else {
                            retValue.append(String.valueOf(si.getTimes()));
                        }
                    } else if ("TIMEUNIT".equals(aLabel)) {
                        retValue.append(String.valueOf(si.getTimeUnit()));
                    } else if ("RANGE".equals(aLabel)) {
                        retValue.append(aPC.getSpellRange(selectedCSpell, si));
                    } else if ("BASEPPCOST".equals(aLabel)) {
                        retValue.append(aSpell.getSafe(IntegerKey.PP_COST));
                    } else if ("CASTERLEVEL".equals(aLabel)) {
                        retValue.append(aPC.getCasterLevelForSpell(selectedCSpell));
                    } else if ("CASTINGTIME".equals(aLabel)) {
                        retValue.append(aSpell.getListAsString(ListKey.CASTTIME));
                    } else if ("COMPONENTS".equals(aLabel)) {
                        retValue.append(aSpell.getListAsString(ListKey.COMPONENTS));
                    } else if ("CONCENTRATION".equals(aLabel)) {
                        if (SettingsHandler.getGame().getSpellBaseConcentration() != "") {
                            int concentration = aPC.getConcentration(aSpell, selectedCSpell, si);
                            retValue.append(Delta.toString((int)concentration));
                        }
                    } else if ("COST".equals(aLabel)) {
                        retValue.append(((BigDecimal)aSpell.getSafe(ObjectKey.COST)).toString());
                    } else if ("DC".equals(aLabel)) {
                        String SaveInfo = aSpell.getListAsString(ListKey.SAVE_INFO);
                        if (!("".equals(SaveInfo) || "None".equals(SaveInfo) || "No".equals(SaveInfo))) {
                            int dc = aPC.getDC(aSpell, selectedCSpell, si);
                            retValue.append(String.valueOf(dc));
                        }
                    } else if ("DURATION".equals(aLabel)) {
                        mString = aPC.parseSpellString(selectedCSpell, aSpell.getListAsString(ListKey.DURATION));
                        retValue.append(mString);
                    } else if ("DESC".equals(aLabel) || "EFFECT".equals(aLabel)) {
                        mString = aPC.parseSpellString(selectedCSpell, aPC.getDescription((PObject)aSpell));
                        retValue.append(mString);
                    } else if ("TARGET".equals(aLabel) || "EFFECTYPE".equals(aLabel)) {
                        mString = aPC.parseSpellString(selectedCSpell, aSpell.getSafe(StringKey.TARGET_AREA));
                        retValue.append(mString);
                    } else if ("SAVEINFO".equals(aLabel)) {
                        retValue.append(aSpell.getListAsString(ListKey.SAVE_INFO));
                    } else if ("SCHOOL".equals(aLabel)) {
                        retValue.append(aSpell.getListAsString(ListKey.SPELL_SCHOOL));
                    } else if ("SOURCELEVEL".equals(aLabel)) {
                        retValue.append(SpellMemToken.replaceTokenSpellMemSourceLevel(aSpell, aPC));
                    } else if ("SOURCE".equals(aLabel)) {
                        retValue.append(SourceFormat.getFormattedString((CDOMObject)aSpell, (SourceFormat)Globals.getSourceDisplay(), (boolean)true));
                    } else if ("SOURCESHORT".equals(aLabel)) {
                        retValue.append(SourceFormat.formatShort((CDOMObject)aSpell, (int)8));
                    } else if ("SOURCEPAGE".equals(aLabel)) {
                        retValue.append(aSpell.get(StringKey.SOURCE_PAGE));
                    } else if ("SOURCEWEB".equals(aLabel)) {
                        aTemp = aSpell.get(StringKey.SOURCE_WEB);
                        if (aTemp != null && !aTemp.isEmpty()) {
                            retValue.append(aTemp);
                        }
                    } else if ("SOURCELINK".equals(aLabel)) {
                        aTemp = aSpell.get(StringKey.SOURCE_LINK);
                        if (aTemp != null && !aTemp.isEmpty()) {
                            retValue.append(aTemp);
                        }
                    } else if ("SUBSCHOOL".equals(aLabel)) {
                        retValue.append(aSpell.getListAsString(ListKey.SPELL_SUBSCHOOL));
                    } else if ("DESCRIPTOR".equals(aLabel)) {
                        retValue.append(aSpell.getListAsString(ListKey.SPELL_DESCRIPTOR));
                    } else if ("FULLSCHOOL".equals(aLabel)) {
                        aTemp = aSpell.getListAsString(ListKey.SPELL_SCHOOL);
                        if (aSpell.getListAsString(ListKey.SPELL_SUBSCHOOL).length() > 0 && !"NONE".equalsIgnoreCase(aSpell.getListAsString(ListKey.SPELL_SUBSCHOOL).trim())) {
                            aTemp = aTemp + " (" + aSpell.getListAsString(ListKey.SPELL_SUBSCHOOL) + ')';
                        }
                        if (aSpell.getListAsString(ListKey.SPELL_DESCRIPTOR).length() > 0) {
                            aTemp = aTemp + " [" + aSpell.getListAsString(ListKey.SPELL_DESCRIPTOR) + ']';
                        }
                        retValue.append(aTemp);
                    } else if ("SR".equals(aLabel)) {
                        retValue.append(aSpell.getListAsString(ListKey.SPELL_RESISTANCE));
                    } else if ("SRSHORT".equals(aLabel)) {
                        if ("No".equals(aSpell.getListAsString(ListKey.SPELL_RESISTANCE))) {
                            retValue.append("N");
                        } else {
                            retValue.append("Y");
                        }
                    } else if ("CLASS".equals(aLabel)) {
                        retValue.append(OutputNameFormatting.getOutputName((CDOMObject)aObject));
                    } else if ("DCSTAT".equals(aLabel)) {
                        if (aObject instanceof PCClass) {
                            aClass = (PCClass)aObject;
                            retValue.append(aClass.getSpellBaseStat());
                        }
                    } else if ("TYPE".equals(aLabel)) {
                        aClass = null;
                        if (aObject instanceof PCClass) {
                            aClass = (PCClass)aObject;
                        }
                        if (aClass != null) {
                            retValue.append(aClass.getSpellType());
                        }
                    } else if (aLabel.startsWith("DESCRIPTION")) {
                        sString = SpellMemToken.getItemDescription("SPELL", aSpell.getKeyName(), aPC.getDescription((PObject)aSpell), aPC);
                        if (altLabel.length() > 0) {
                            retValue.append(sString.replaceAll("\r?\n", altLabel));
                        } else {
                            retValue.append(sString);
                        }
                    } else if (aLabel.startsWith("BONUSSPELL")) {
                        sString = "*";
                        if (aLabel.length() > 10) {
                            sString = aLabel.substring(10);
                        }
                        retValue.append(this.getBonusSpellValue(aPC, spellLevel, sString, altLabel, aObject, bookName, selectedCSpell, aSpell));
                    } else if ("XPCOST".equals(aLabel)) {
                        retValue.append(aSpell.getSafe(IntegerKey.XP_COST));
                    } else if ("CT".equals(aLabel)) {
                        retValue.append(aSpell.getSafe(IntegerKey.CASTING_THRESHOLD));
                    }
                } else if (eh != null && eh.getExistsOnly()) {
                    eh.setNoMoreItems(true);
                }
            } else if (eh != null && eh.getExistsOnly()) {
                eh.setNoMoreItems(true);
            }
        }
        return retValue.toString();
    }

    private String getAppliedName(SpellInfo si) {
        List featList = si.getFeatList();
        if (featList == null || featList.isEmpty()) {
            return "";
        }
        StringBuilder aBuf = new StringBuilder(50);
        for (int i = 0; i < featList.size(); ++i) {
            Object an = ((Ability)featList.get(i)).getResolved(FactKey.valueOf((String)"AppliedName"));
            aBuf.append(an == null ? "" : an);
            if (i >= featList.size()) continue;
            aBuf.append(" ");
        }
        return aBuf.toString();
    }

    private String getBonusSpellValue(PlayerCharacter aPC, int spellLevel, String sString, String altLabel, PObject aObject, String bookName, CharacterSpell cs, Spell aSpell) {
        StringBuilder retValue = new StringBuilder();
        if (aObject != null && cs != null && cs.isSpecialtySpell(aPC) && aObject instanceof PCClass) {
            List charSpells = aPC.getCharacterSpells((CDOMObject)aObject, aSpell, bookName, spellLevel);
            boolean isDomainOnly = true;
            for (CharacterSpell cSpell : charSpells) {
                if (cSpell.isSpecialtySpell(aPC)) continue;
                isDomainOnly = false;
                break;
            }
            if (isDomainOnly) {
                retValue.append(sString);
            } else {
                retValue.append(sString + sString);
            }
        } else {
            retValue.append(altLabel);
        }
        return retValue.toString();
    }

    private static String replaceTokenSpellMemSourceLevel(Spell aSpell, PlayerCharacter aPC) {
        HashMapToList tempHash = aPC.getSpellLevelInfo(aSpell);
        StringBuilder tempSource = new StringBuilder();
        TreeSet<String> levelSet = new TreeSet<String>();
        for (CDOMList spellList : tempHash.getKeySet()) {
            String classKey = spellList.getKeyName();
            for (Integer lvl : tempHash.getListFor((Object)spellList)) {
                PCClass pcc = (PCClass)Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, classKey);
                if (pcc != null) {
                    classKey = pcc.getAbbrev();
                }
                levelSet.add(classKey + lvl.toString());
            }
        }
        for (String levelString : levelSet) {
            if (tempSource.length() > 0) {
                tempSource.append(", ");
            }
            tempSource.append(levelString);
        }
        return tempSource.toString();
    }

    public static String getItemDescription(String sType, String sKey, String sAlt, PlayerCharacter aPC) {
        if (SettingsHandler.isROG()) {
            if ("EMPTY".equals(aPC.getDescriptionLst())) {
                aPC.loadDescriptionFilesInDirectory("descriptions");
            }
            String aDescription = sAlt;
            String aSearch = sType.toUpperCase() + ":" + sKey + Constants.LINE_SEPARATOR;
            int pos = aPC.getDescriptionLst().indexOf(aSearch);
            if (pos >= 0) {
                aDescription = aPC.getDescriptionLst().substring(pos + aSearch.length());
                aDescription = aDescription.substring(0, aDescription.indexOf("####") - 1).trim();
            }
            return aDescription;
        }
        return sAlt;
    }
}

