/*
    huc - HTML-umlaut conversion tool v0.1

    2001 by Hanno Boeck <hanno@gmx.de> - released under the GPL
    http://www.int21.de/huc/ - report bugs to hanno@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <string>
#include <fstream>
#include <iostream>

using namespace std;

bool noquot=false;
bool noamp=false;
bool breakconv=false;

int processfile(char * filename)
{
 ifstream source(filename);
 if (!source) {cout <<"Read error!\n";return 1;}

 string f1,f2;
 char ch;
 cout <<"Converting "<<filename<<"...";
 while (source.get(ch)) f1+=ch;
 source.close();

 int tag=0;
 for(int i=0;i<f1.size();i++)
 {
       if (f1[i]=='') f2+="&iexcl;";
  else if (f1[i]=='') f2+="&cent;";
  else if (f1[i]=='') f2+="&pound;";
  else if (f1[i]=='') f2+="&yen;";
  else if (f1[i]=='|') f2+="&brvbar;";
  else if (f1[i]=='') f2+="&sect;";
  else if (f1[i]=='') f2+="&copy;";
  else if (f1[i]=='') f2+="&ordf;";
  else if (f1[i]=='') f2+="&laquo;";
  else if (f1[i]=='') f2+="&not;";
  else if (f1[i]=='') f2+="&shy;";
  else if (f1[i]=='') f2+="&reg;";
  else if (f1[i]=='') f2+="&macr;";
  else if (f1[i]=='') f2+="&deg;";
  else if (f1[i]=='') f2+="&plusmn;";
  else if (f1[i]=='') f2+="&sup2;";
  else if (f1[i]=='') f2+="&sup3;";
  else if (f1[i]=='') f2+="&micro;";
  else if (f1[i]=='') f2+="&para;";
  else if (f1[i]=='') f2+="&middot;";
  else if (f1[i]=='') f2+="&sup1;";
  else if (f1[i]=='') f2+="&ordm;";
  else if (f1[i]=='') f2+="&raquo;";
  else if (f1[i]=='') f2+="&iquest;";
  else if (f1[i]=='') f2+="&Agrave;";
  else if (f1[i]=='') f2+="&Aacute;";
  else if (f1[i]=='') f2+="&Acirc;";
  else if (f1[i]=='') f2+="&Atilde;";
  else if (f1[i]=='') f2+="&Auml;";
  else if (f1[i]=='') f2+="&Acirc;";
  else if (f1[i]=='') f2+="&AElig;";
  else if (f1[i]=='') f2+="&Ccedil;";
  else if (f1[i]=='') f2+="&Egrave;";
  else if (f1[i]=='') f2+="&Eacute;";
  else if (f1[i]=='') f2+="&Ecirc;";
  else if (f1[i]=='') f2+="&Euml;";
  else if (f1[i]=='') f2+="&Igrave;";
  else if (f1[i]=='') f2+="&Iacute;";
  else if (f1[i]=='') f2+="&Icirc;";
  else if (f1[i]=='') f2+="&Iuml;";
  else if (f1[i]=='') f2+="&ETH;";
  else if (f1[i]=='') f2+="&Ntilde;";
  else if (f1[i]=='') f2+="&Ograve;";
  else if (f1[i]=='') f2+="&Oacute;";
  else if (f1[i]=='') f2+="&Ocirc;";
  else if (f1[i]=='') f2+="&Otilde;";
  else if (f1[i]=='') f2+="&Ouml;";
  else if (f1[i]=='') f2+="&times;";
  else if (f1[i]=='') f2+="&Oslash;";
  else if (f1[i]=='') f2+="&Ugrave;";
  else if (f1[i]=='') f2+="&Uacute;";
  else if (f1[i]=='') f2+="&Ucirc;";
  else if (f1[i]=='') f2+="&Uuml;";
  else if (f1[i]=='') f2+="&Yacute;";
  else if (f1[i]=='') f2+="&THORN;";
  else if (f1[i]=='') f2+="&szlig;";
  else if (f1[i]=='') f2+="&agrave;";
  else if (f1[i]=='') f2+="&aacute;";
  else if (f1[i]=='') f2+="&acirc;";
  else if (f1[i]=='') f2+="&atilde;";
  else if (f1[i]=='') f2+="&auml;";
  else if (f1[i]=='') f2+="&aring;";
  else if (f1[i]=='') f2+="&aelig;";
  else if (f1[i]=='') f2+="&ccedil;";
  else if (f1[i]=='') f2+="&egrave;";
  else if (f1[i]=='') f2+="&eacute;";
  else if (f1[i]=='') f2+="&ecirc;";
  else if (f1[i]=='') f2+="&euml;";
  else if (f1[i]=='') f2+="&igrave;";
  else if (f1[i]=='') f2+="&iacute;";
  else if (f1[i]=='') f2+="&icirc;";
  else if (f1[i]=='') f2+="&iuml;";
  else if (f1[i]=='') f2+="&eth;";
  else if (f1[i]=='') f2+="&ntilde;";
  else if (f1[i]=='') f2+="&ograve;";
  else if (f1[i]=='') f2+="&oacute;";
  else if (f1[i]=='') f2+="&ocirc;";
  else if (f1[i]=='') f2+="&otilde;";
  else if (f1[i]=='') f2+="&ouml;";
  else if (f1[i]=='') f2+="&divide;";
  else if (f1[i]=='') f2+="&oslash;";
  else if (f1[i]=='') f2+="&ugrave;";
  else if (f1[i]=='') f2+="&uacute;";
  else if (f1[i]=='') f2+="&ucirc;";
  else if (f1[i]=='') f2+="&uuml;";
  else if (f1[i]=='') f2+="&yacute;";
  else if (f1[i]=='') f2+="&thorn;";
  else if (f1[i]=='') f2+="&yuml;";
  else if (f1[i]=='&' && (f1[i+1]==' ' || f1[i+1]==13) && !noamp) f2+="&amp;";
  else if (f1[i]==13 && breakconv) f2+="";
  else f2+=f1[i];
 }

 ofstream target(filename);
 if (!target) {cout<<"Write error!\n";return 1;}

 target << f2;
 target.close();
 cout <<"OK\n";
 return 0;
}

int main(int parc,char** par)
{
 cout
 <<"huc - HTML-umlaut conversion tool v0.1\n\n";
 if (parc<=1) cout
 <<"Syntax: huc [option] [filename] [filename] ...\n\n"
 <<"-a Ignore amps (& -> &amp;)\n"
 <<"-b Convert DOS-Break (0Dh 0Ah) to Unix-Break (0Ah)\n"
 <<"\n"
 <<"2001 by Hanno Boeck <hanno@gmx.de> - released under the GPL\n"
 <<"http://www.int21.de/huc/ - report bugs to hanno@gmx.de\n";
 
 for(int i=1;i<parc;i++)
 {
  if (par[i][0]=='-')
  {
   if (par[i][1]=='a') noamp=true;
   if (par[i][1]=='b') breakconv=true;
  }
 }
 
 for(int i=1;i<parc;i++)
  if (par[i][0]!='-') processfile(par[i]);

}
