/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import java.util.Vector;

public final class UnpickleContext {
    byte[] m_image;
    int m_offset;
    int m_beginOffset;
    int m_markedOffset;
    Vector m_patches;
    long[] m_ldsOffsets;
    boolean[] m_nullIndicators;
    boolean m_bigEndian;

    public UnpickleContext() {
    }

    public UnpickleContext(byte[] byArray, int n, boolean[] blArray, long[] lArray, boolean bl) {
        this.m_image = byArray;
        this.m_beginOffset = n;
        this.m_offset = n;
        this.m_bigEndian = bl;
        this.m_nullIndicators = blArray;
        this.m_patches = null;
        this.m_ldsOffsets = lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte read_byte() throws SQLException {
        try {
            byte by = this.m_image[this.m_offset];
            Object var3_2 = null;
            ++this.m_offset;
            return by;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.m_offset;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read_varNumBytes() throws SQLException {
        byte[] byArray = new byte[this.m_image[this.m_offset] & 0xFF];
        try {
            System.arraycopy(this.m_image, this.m_offset + 1, byArray, 0, byArray.length);
            Object var3_2 = null;
            this.m_offset += 22;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_offset += 22;
            throw throwable;
        }
        return byArray;
    }

    public byte[] read_ptrBytes() throws SQLException {
        byte[] byArray = new byte[(this.m_image[this.m_offset] & 0xFF) * 256 + (this.m_image[this.m_offset + 1] & 0xFF) + 2];
        System.arraycopy(this.m_image, this.m_offset, byArray, 0, byArray.length);
        this.m_offset += byArray.length;
        return byArray;
    }

    public void skip_ptrBytes() throws SQLException {
        this.m_offset += (this.m_image[this.m_offset] & 0xFF) * 256 + (this.m_image[this.m_offset + 1] & 0xFF) + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read_bytes(int n) throws SQLException {
        try {
            byte[] byArray = new byte[n];
            System.arraycopy(this.m_image, this.m_offset, byArray, 0, n);
            byte[] byArray2 = byArray;
            Object var5_4 = null;
            this.m_offset += n;
            return byArray2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_offset += n;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read_long() throws SQLException {
        try {
            long l = (((this.m_image[this.m_offset] & 0xFF) * 256 + (this.m_image[this.m_offset + 1] & 0xFF)) * 256 + (this.m_image[this.m_offset + 2] & 0xFF)) * 256 + (this.m_image[this.m_offset + 3] & 0xFF);
            Object var4_2 = null;
            this.m_offset += 4;
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.m_offset += 4;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short read_short() throws SQLException {
        try {
            short s = (short)((this.m_image[this.m_offset] & 0xFF) * 256 + (this.m_image[this.m_offset + 1] & 0xFF));
            Object var3_2 = null;
            this.m_offset += 2;
            return s;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_offset += 2;
            throw throwable;
        }
    }

    public byte[] read_lengthBytes() throws SQLException {
        long l = this.read_long();
        return this.read_bytes((int)l);
    }

    public void skip_lengthBytes() throws SQLException {
        long l = this.read_long();
        this.m_offset = (int)((long)this.m_offset + l);
    }

    public void skip_to(long l) throws SQLException {
        if (l > (long)(this.m_offset - this.m_beginOffset)) {
            this.m_offset = this.m_beginOffset + (int)l;
        }
    }

    public void skip_to(int n) throws SQLException {
        if (n > this.m_offset - this.m_beginOffset) {
            this.m_offset = this.m_beginOffset + n;
        }
    }

    public void mark() throws SQLException {
        this.m_markedOffset = this.m_offset;
    }

    public void reset() throws SQLException {
        this.m_offset = this.m_markedOffset;
    }

    public void markAndSkip() throws SQLException {
        this.m_markedOffset = this.m_offset + 4;
        this.m_offset = this.m_beginOffset + (int)this.read_long();
    }

    public void markAndSkip(long l) throws SQLException {
        this.m_markedOffset = this.m_offset;
        this.m_offset = this.m_beginOffset + (int)l;
    }

    public void skip_bytes(int n) throws SQLException {
        if (n >= 0) {
            this.m_offset += n;
        }
    }

    public boolean is_null(int n) {
        return this.m_nullIndicators[n];
    }

    public int absolute_offset() throws SQLException {
        return this.m_offset;
    }

    public int offset() throws SQLException {
        return this.m_offset - this.m_beginOffset;
    }

    public byte[] image() throws SQLException {
        return this.m_image;
    }
}

