/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.codehaus.groovy.reflection.CachedField;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.runtime.metaclass.ClosureMetaMethod;
import org.codehaus.groovy.runtime.metaclass.ReflectionMetaMethod;
import org.spockframework.util.UnreachableCodeError;

public abstract class MopUtil {
    private static final Field ReflectionMetaMethod_method = MopUtil.getDeclaredField(ReflectionMetaMethod.class, "method");
    private static final Field CachedField_field = MopUtil.getDeclaredField(CachedField.class, "field");

    private static Field getDeclaredField(Class clazz, String name) {
        try {
            Field result = clazz.getDeclaredField(name);
            result.setAccessible(true);
            return result;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(String.format("Found an incompatibility between the Spock and Groovy versions you are using: field '%s.%s' does not exist.", clazz, name));
        }
    }

    public static Method methodFor(MetaMethod method) {
        if (method instanceof CachedMethod) {
            return ((CachedMethod)method).getCachedMethod();
        }
        if (method instanceof ClosureMetaMethod) {
            return ((ClosureMetaMethod)method).getDoCall().getCachedMethod();
        }
        if (method instanceof ReflectionMetaMethod) {
            try {
                return ((CachedMethod)ReflectionMetaMethod_method.get(method)).getCachedMethod();
            }
            catch (IllegalAccessException e) {
                throw new UnreachableCodeError(e);
            }
        }
        return null;
    }

    public static Member memberFor(MetaProperty property) {
        if (property instanceof CachedField) {
            try {
                return (Member)CachedField_field.get(property);
            }
            catch (IllegalAccessException e) {
                throw new UnreachableCodeError(e);
            }
        }
        if (property instanceof MetaBeanProperty) {
            MetaBeanProperty mbp = (MetaBeanProperty)property;
            if (mbp.getGetter() != null) {
                return MopUtil.methodFor(mbp.getGetter());
            }
            if (mbp.getSetter() != null) {
                return MopUtil.methodFor(mbp.getSetter());
            }
            if (mbp.getField() != null) {
                return MopUtil.memberFor((MetaProperty)mbp.getField());
            }
            return null;
        }
        return null;
    }

    public static Field fieldFor(MetaProperty property) {
        if (property instanceof CachedField) {
            try {
                return (Field)CachedField_field.get(property);
            }
            catch (IllegalAccessException e) {
                throw new UnreachableCodeError(e);
            }
        }
        if (property instanceof MetaBeanProperty) {
            MetaBeanProperty mbp = (MetaBeanProperty)property;
            if (mbp.getField() != null) {
                return MopUtil.fieldFor((MetaProperty)mbp.getField());
            }
            return null;
        }
        return null;
    }

    public static Method getterFor(MetaProperty property) {
        if (property instanceof MetaBeanProperty) {
            MetaBeanProperty mbp = (MetaBeanProperty)property;
            if (mbp.getGetter() != null) {
                return MopUtil.methodFor(mbp.getGetter());
            }
            return null;
        }
        return null;
    }

    public static Method setterFor(MetaProperty property) {
        if (property instanceof MetaBeanProperty) {
            MetaBeanProperty mbp = (MetaBeanProperty)property;
            if (mbp.getSetter() != null) {
                return MopUtil.methodFor(mbp.getSetter());
            }
            return null;
        }
        return null;
    }

    public static boolean isReadable(MetaProperty property) {
        if (property instanceof CachedField) {
            return true;
        }
        if (property instanceof MetaBeanProperty) {
            MetaBeanProperty mbp = (MetaBeanProperty)property;
            return mbp.getGetter() != null || mbp.getField() != null;
        }
        return false;
    }

    public static boolean isWriteable(MetaProperty property) {
        if (property instanceof CachedField) {
            return true;
        }
        if (property instanceof MetaBeanProperty) {
            MetaBeanProperty mbp = (MetaBeanProperty)property;
            return mbp.getSetter() != null || mbp.getField() != null;
        }
        return false;
    }
}

