/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.util.HashMap;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseUnit<Q extends Quantity>
extends Unit<Q> {
    private final String _symbol;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseUnit(String symbol) {
        this._symbol = symbol;
        HashMap<String, Unit<?>> hashMap = Unit.SYMBOL_TO_UNIT;
        synchronized (hashMap) {
            Unit<?> unit = Unit.SYMBOL_TO_UNIT.get(symbol);
            if (unit == null) {
                Unit.SYMBOL_TO_UNIT.put(symbol, this);
                return;
            }
            if (!(unit instanceof BaseUnit)) {
                throw new IllegalArgumentException("Symbol " + symbol + " is associated to a different unit");
            }
        }
    }

    public final String getSymbol() {
        return this._symbol;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof BaseUnit)) {
            return false;
        }
        BaseUnit thatUnit = (BaseUnit)that;
        return this._symbol.equals(thatUnit._symbol);
    }

    @Override
    public int hashCode() {
        return this._symbol.hashCode();
    }

    @Override
    public Unit<Q> toSI() {
        return this;
    }

    @Override
    public final UnitConverter getConverterTo(Unit<Q> unit) {
        return unit.equals(this) ? UnitConverter.IDENTITY : super.getConverterTo(unit);
    }
}

