/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.IGame;
import megamek.common.Mounted;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.ACWeaponHandler;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.RACHandler;
import megamek.common.weapons.UACWeapon;
import megamek.common.weapons.UltraWeaponHandler;
import megamek.server.Server;

public abstract class RACWeapon
extends UACWeapon {
    private static final long serialVersionUID = 659000035767322660L;

    public RACWeapon() {
        this.ammoType = 23;
        String[] stringArray = new String[]{"Single", "2-shot", "3-shot", "4-shot", "5-shot", "6-shot"};
        this.setModes(stringArray);
        this.explosive = true;
        this.explosionDamage = this.damage;
        this.atClass = 7;
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        Mounted mounted = iGame.getEntity(weaponAttackAction.getEntityId()).getEquipment(weaponAttackAction.getWeaponId());
        if (mounted.curMode().equals("6-shot") || mounted.curMode().equals("5-shot") || mounted.curMode().equals("4-shot") || mounted.curMode().equals("3-shot")) {
            return new RACHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (mounted.curMode().equals("2-shot")) {
            return new UltraWeaponHandler(toHitData, weaponAttackAction, iGame, server);
        }
        return new ACWeaponHandler(toHitData, weaponAttackAction, iGame, server);
    }
}

