/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.DisplayMapSet;
import megamek.client.ui.AWT.widget.PMAreasGroup;
import megamek.client.ui.AWT.widget.PMPicArea;
import megamek.client.ui.AWT.widget.PMSimpleLabel;
import megamek.client.ui.AWT.widget.PMUtil;
import megamek.client.ui.AWT.widget.PMValueLabel;
import megamek.common.Aero;
import megamek.common.Entity;
import megamek.common.FighterSquadron;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SquadronMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private Component comp;
    private Image[] armorImage = new Image[FighterSquadron.MAX_SIZE];
    private PMPicArea[] armorArea = new PMPicArea[FighterSquadron.MAX_SIZE];
    private Image[] avCritImage = new Image[FighterSquadron.MAX_SIZE];
    private PMPicArea[] avCritArea = new PMPicArea[FighterSquadron.MAX_SIZE];
    private Image[] engineCritImage = new Image[FighterSquadron.MAX_SIZE];
    private PMPicArea[] engineCritArea = new PMPicArea[FighterSquadron.MAX_SIZE];
    private Image[] fcsCritImage = new Image[FighterSquadron.MAX_SIZE];
    private PMPicArea[] fcsCritArea = new PMPicArea[FighterSquadron.MAX_SIZE];
    private Image[] sensorCritImage = new Image[FighterSquadron.MAX_SIZE];
    private PMPicArea[] sensorCritArea = new PMPicArea[FighterSquadron.MAX_SIZE];
    private Image[] pilotCritImage = new Image[FighterSquadron.MAX_SIZE];
    private PMPicArea[] pilotCritArea = new PMPicArea[FighterSquadron.MAX_SIZE];
    private PMSimpleLabel[] nameLabel = new PMSimpleLabel[FighterSquadron.MAX_SIZE];
    private PMValueLabel[] armorVLabel = new PMValueLabel[FighterSquadron.MAX_SIZE];
    private PMSimpleLabel[] avCritLabel = new PMSimpleLabel[FighterSquadron.MAX_SIZE];
    private PMSimpleLabel[] engineCritLabel = new PMSimpleLabel[FighterSquadron.MAX_SIZE];
    private PMSimpleLabel[] fcsCritLabel = new PMSimpleLabel[FighterSquadron.MAX_SIZE];
    private PMSimpleLabel[] sensorCritLabel = new PMSimpleLabel[FighterSquadron.MAX_SIZE];
    private PMSimpleLabel[] pilotCritLabel = new PMSimpleLabel[FighterSquadron.MAX_SIZE];
    private Vector<BackGroundDrawer> bgDrawers = new Vector();
    private PMAreasGroup content = new PMAreasGroup();
    private int stepY = 11;
    private int squareSize = 7;
    private int armorRows = 6;
    private int armorCols = 8;
    private static final Font FONT_LABEL = new Font("SansSerif", 0, 9);

    public SquadronMapSet(Component component) {
        this.comp = component;
        this.setAreas();
        this.setLabels();
        this.setBackGround();
        this.translateAreas();
        this.setContent();
    }

    public void setRest() {
    }

    @Override
    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    @Override
    public Vector<BackGroundDrawer> getBackgroundDrawers() {
        return this.bgDrawers;
    }

    @Override
    public void setEntity(Entity entity) {
        int n;
        FighterSquadron fighterSquadron = (FighterSquadron)entity;
        for (n = 0; n < fighterSquadron.getN0Fighters(); ++n) {
            Aero aero = fighterSquadron.getFighter(n);
            int n2 = aero.getCapArmor();
            int n3 = aero.getCap0Armor();
            this.drawArmorImage(this.armorImage[n], n2, n3);
            this.armorVLabel[n].setValue(Integer.toString(n2));
            this.drawCrits(this.avCritImage[n], aero.getAvionicsHits());
            this.drawCrits(this.engineCritImage[n], aero.getEngineHits());
            this.drawCrits(this.fcsCritImage[n], aero.getFCSHits());
            this.drawCrits(this.sensorCritImage[n], aero.getSensorHits());
            this.drawCrits(this.pilotCritImage[n], aero.getCrew().getHits());
            this.nameLabel[n].setString(aero.getDisplayName());
            this.armorArea[n].setVisible(true);
            this.armorVLabel[n].setVisible(true);
            this.avCritArea[n].setVisible(true);
            this.engineCritArea[n].setVisible(true);
            this.fcsCritArea[n].setVisible(true);
            this.sensorCritArea[n].setVisible(true);
            this.pilotCritArea[n].setVisible(true);
            this.nameLabel[n].setVisible(true);
            this.avCritLabel[n].setVisible(true);
            this.engineCritLabel[n].setVisible(true);
            this.fcsCritLabel[n].setVisible(true);
            this.sensorCritLabel[n].setVisible(true);
            this.pilotCritLabel[n].setVisible(true);
        }
        for (n = fighterSquadron.getN0Fighters(); n < FighterSquadron.MAX_SIZE; ++n) {
            this.armorArea[n].setVisible(false);
            this.armorVLabel[n].setVisible(false);
            this.avCritArea[n].setVisible(false);
            this.engineCritArea[n].setVisible(false);
            this.fcsCritArea[n].setVisible(false);
            this.sensorCritArea[n].setVisible(false);
            this.pilotCritArea[n].setVisible(false);
            this.nameLabel[n].setVisible(false);
            this.avCritLabel[n].setVisible(false);
            this.engineCritLabel[n].setVisible(false);
            this.fcsCritLabel[n].setVisible(false);
            this.sensorCritLabel[n].setVisible(false);
            this.pilotCritLabel[n].setVisible(false);
        }
    }

    private void setContent() {
        for (int i = 0; i < FighterSquadron.MAX_SIZE; ++i) {
            this.content.addArea(this.nameLabel[i]);
            this.content.addArea(this.armorArea[i]);
            this.content.addArea(this.armorVLabel[i]);
            this.content.addArea(this.avCritLabel[i]);
            this.content.addArea(this.engineCritLabel[i]);
            this.content.addArea(this.fcsCritLabel[i]);
            this.content.addArea(this.sensorCritLabel[i]);
            this.content.addArea(this.pilotCritLabel[i]);
            this.content.addArea(this.avCritArea[i]);
            this.content.addArea(this.engineCritArea[i]);
            this.content.addArea(this.fcsCritArea[i]);
            this.content.addArea(this.sensorCritArea[i]);
            this.content.addArea(this.pilotCritArea[i]);
        }
    }

    private void setAreas() {
        for (int i = 0; i < FighterSquadron.MAX_SIZE; ++i) {
            this.armorImage[i] = this.comp.createImage(this.armorCols * (this.squareSize + 1), this.armorRows * (this.squareSize + 1));
            this.armorArea[i] = new PMPicArea(this.armorImage[i]);
            this.avCritImage[i] = this.comp.createImage(3 * (this.squareSize + 1), this.squareSize + 1);
            this.avCritArea[i] = new PMPicArea(this.avCritImage[i]);
            this.engineCritImage[i] = this.comp.createImage(3 * (this.squareSize + 1), this.squareSize + 1);
            this.engineCritArea[i] = new PMPicArea(this.engineCritImage[i]);
            this.fcsCritImage[i] = this.comp.createImage(3 * (this.squareSize + 1), this.squareSize + 1);
            this.fcsCritArea[i] = new PMPicArea(this.fcsCritImage[i]);
            this.sensorCritImage[i] = this.comp.createImage(3 * (this.squareSize + 1), this.squareSize + 1);
            this.sensorCritArea[i] = new PMPicArea(this.sensorCritImage[i]);
            this.pilotCritImage[i] = this.comp.createImage(6 * (this.squareSize + 1), this.squareSize + 1);
            this.pilotCritArea[i] = new PMPicArea(this.pilotCritImage[i]);
        }
    }

    private void setLabels() {
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_LABEL);
        for (int i = 0; i < FighterSquadron.MAX_SIZE; ++i) {
            this.nameLabel[i] = new PMSimpleLabel("Unknown", fontMetrics, Color.white);
            this.armorVLabel[i] = new PMValueLabel(fontMetrics, Color.red.brighter());
            this.avCritLabel[i] = new PMSimpleLabel("Avionics:", fontMetrics, Color.white);
            this.engineCritLabel[i] = new PMSimpleLabel("Engine:", fontMetrics, Color.white);
            this.fcsCritLabel[i] = new PMSimpleLabel("FCS:", fontMetrics, Color.white);
            this.sensorCritLabel[i] = new PMSimpleLabel("Sensors:", fontMetrics, Color.white);
            this.pilotCritLabel[i] = new PMSimpleLabel("Pilot hits:", fontMetrics, Color.white);
        }
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 20;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 68;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 258;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 273;
        image = this.comp.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 321;
        image = this.comp.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.comp.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.comp.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
    }

    private void translateAreas() {
        int n = 6 * this.stepY;
        for (int i = 0; i < FighterSquadron.MAX_SIZE; ++i) {
            this.nameLabel[i].translate(0, n * i);
            this.armorArea[i].translate(0, this.squareSize + n * i);
            this.armorVLabel[i].translate(this.armorCols * (this.squareSize + 1) / 2, n * i + this.squareSize + this.armorRows * (this.squareSize + 1) / 2);
            this.avCritLabel[i].translate(5 + this.armorCols * (this.squareSize + 1), this.stepY + n * i);
            this.engineCritLabel[i].translate(5 + this.armorCols * (this.squareSize + 1), 2 * this.stepY + n * i);
            this.fcsCritLabel[i].translate(5 + this.armorCols * (this.squareSize + 1), 3 * this.stepY + n * i);
            this.sensorCritLabel[i].translate(5 + this.armorCols * (this.squareSize + 1), 4 * this.stepY + n * i);
            this.pilotCritLabel[i].translate(5 + this.armorCols * (this.squareSize + 1), 5 * this.stepY + n * i);
            this.avCritArea[i].translate(10 + this.pilotCritLabel[0].width + this.armorCols * (this.squareSize + 1), this.stepY - (this.squareSize + 1) + n * i);
            this.engineCritArea[i].translate(10 + this.pilotCritLabel[0].width + this.armorCols * (this.squareSize + 1), 2 * this.stepY - (this.squareSize + 1) + n * i);
            this.fcsCritArea[i].translate(10 + this.pilotCritLabel[0].width + this.armorCols * (this.squareSize + 1), 3 * this.stepY - (this.squareSize + 1) + n * i);
            this.sensorCritArea[i].translate(10 + this.pilotCritLabel[0].width + this.armorCols * (this.squareSize + 1), 4 * this.stepY - (this.squareSize + 1) + n * i);
            this.pilotCritArea[i].translate(10 + this.pilotCritLabel[0].width + this.armorCols * (this.squareSize + 1), 5 * this.stepY - (this.squareSize + 1) + n * i);
        }
    }

    private void drawCrits(Image image, int n) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n2, n3);
        for (int i = 0; i < n; ++i) {
            graphics.setColor(Color.red.darker());
            graphics.fillRect(i * (this.squareSize + 1), 0, this.squareSize, this.squareSize);
        }
    }

    private void drawArmorImage(Image image, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.gray);
        graphics.fillRect(0, 0, n6, n7);
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = n5 / this.armorRows;
            n3 = n5 - n4 * this.armorRows;
            graphics.setColor(Color.black);
            graphics.fillRect(n4 * (this.squareSize + 1), n3 * (this.squareSize + 1), this.squareSize + 1, this.squareSize + 1);
        }
        for (n5 = 0; n5 < n; ++n5) {
            n4 = n5 / this.armorRows;
            n3 = n5 - n4 * this.armorRows;
            graphics.setColor(Color.green.darker());
            graphics.fillRect(n4 * (this.squareSize + 1), n3 * (this.squareSize + 1), this.squareSize, this.squareSize);
        }
    }
}

