/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import megamek.client.ui.AWT.boardview3d.ArrowModel;
import megamek.client.ui.AWT.boardview3d.BoardModel;
import megamek.client.ui.AWT.boardview3d.C;
import megamek.client.ui.AWT.boardview3d.LabelModel;
import megamek.client.ui.AWT.boardview3d.ViewTransform;
import megamek.client.ui.AWT.util.PlayerColors;
import megamek.client.ui.Messages;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Targetable;
import megamek.common.WeaponType;
import megamek.common.actions.AttackAction;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.ProtomechPhysicalAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.SearchlightAttackAction;
import megamek.common.actions.WeaponAttackAction;

class AttackModel
extends ArrowModel {
    IGame game;
    Vector3d labelLocation;
    Color3f color;
    Entity src;
    Targetable trg;

    public AttackModel(AttackAction attackAction, Entity entity, Targetable targetable, IGame iGame) {
        this.game = iGame;
        this.src = entity;
        this.trg = targetable;
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex2 = iGame.getBoard().getHex(targetable.getPosition());
        Point3d point3d = BoardModel.getHexLocation(entity.getPosition(), iHex.surface() + entity.height());
        point3d.z += 3.0;
        Point3d point3d2 = BoardModel.getHexLocation(targetable.getPosition(), iHex2.surface() + targetable.getHeight());
        point3d2.z += 3.0;
        this.setCapability(17);
        this.setUserData(attackAction);
        this.color = new Color3f(PlayerColors.getColor(entity.getOwner().getColorIndex()));
        this.color.scale(0.5f);
        Appearance appearance = new Appearance();
        appearance.setMaterial(new Material(this.color, C.black, this.color, C.white, 64.0f));
        appearance.setColoringAttributes(new ColoringAttributes(this.color, 2));
        appearance.setPolygonAttributes(C.noCull);
        appearance.setLineAttributes(C.defLine);
        Shape3D shape3D = new Shape3D((Geometry)AttackModel.makeArrow(point3d.distance(point3d2)), appearance);
        Shape3D shape3D2 = new Shape3D((Geometry)AttackModel.makeArrowOutline(point3d.distance(point3d2)), appearance);
        this.anim.addChild((Node)shape3D);
        this.anim.addChild((Node)shape3D2);
        Vector3d vector3d = new Vector3d((Tuple3d)point3d);
        vector3d.negate();
        vector3d.add((Tuple3d)point3d2);
        vector3d.y = -vector3d.y;
        double d = vector3d.angle(new Vector3d(0.0, -1.0, 0.0));
        vector3d.cross(vector3d, new Vector3d(0.0, -1.0, 0.0));
        Quat4d quat4d = new Quat4d();
        quat4d.set(new AxisAngle4d(vector3d, d));
        TransformGroup transformGroup = new TransformGroup(new Transform3D(quat4d, new Vector3d((Tuple3d)point3d), 1.0));
        transformGroup.addChild((Node)this.anim);
        this.labelLocation = new Vector3d((Tuple3d)point3d2);
        this.labelLocation.negate();
        this.labelLocation.add((Tuple3d)point3d);
        this.labelLocation.normalize();
        this.labelLocation.scale(15.0);
        this.labelLocation.add((Tuple3d)point3d2);
        this.labelLocation.z += 6.1;
        this.addChild((Node)transformGroup);
    }

    void add(AttackAction attackAction, ViewTransform viewTransform) {
        Object object;
        Object object2 = this.getAllChildren();
        while (object2.hasMoreElements()) {
            object = (Node)object2.nextElement();
            if (!attackAction.equals(object.getUserData())) continue;
            return;
        }
        object2 = "?";
        if (attackAction instanceof WeaponAttackAction) {
            object = (WeaponAttackAction)attackAction;
            WeaponType weaponType = (WeaponType)this.game.getEntity(attackAction.getEntityId()).getEquipment(((WeaponAttackAction)object).getWeaponId()).getType();
            object2 = weaponType.getName() + Messages.getString("BoardView1.needs") + ((WeaponAttackAction)object).toHit(this.game).getValueAsString() + " " + ((WeaponAttackAction)object).toHit(this.game).getTableDesc();
        } else if (attackAction instanceof KickAttackAction) {
            object = (KickAttackAction)attackAction;
            switch (((KickAttackAction)object).getLeg()) {
                case 0: {
                    object2 = Messages.getString("BoardView1.kickBoth", new Object[]{KickAttackAction.toHit(this.game, attackAction.getEntityId(), this.trg, 1).getValueAsString(), KickAttackAction.toHit(this.game, attackAction.getEntityId(), this.trg, 2).getValueAsString()});
                    break;
                }
                case 1: {
                    object2 = Messages.getString("BoardView1.kickLeft", new Object[]{KickAttackAction.toHit(this.game, attackAction.getEntityId(), this.trg, 1).getValueAsString()});
                    break;
                }
                case 2: {
                    object2 = Messages.getString("BoardView1.kickRight", new Object[]{KickAttackAction.toHit(this.game, attackAction.getEntityId(), this.trg, 2).getValueAsString()});
                }
            }
        } else if (attackAction instanceof PunchAttackAction) {
            object = (PunchAttackAction)attackAction;
            switch (((PunchAttackAction)object).getArm()) {
                case 0: {
                    object2 = Messages.getString("BoardView1.punchBoth", new Object[]{PunchAttackAction.toHit(this.game, attackAction.getEntityId(), this.trg, 1).getValueAsString(), PunchAttackAction.toHit(this.game, attackAction.getEntityId(), this.trg, 2).getValueAsString()});
                    break;
                }
                case 1: {
                    object2 = Messages.getString("BoardView1.punchLeft", new Object[]{PunchAttackAction.toHit(this.game, attackAction.getEntityId(), this.trg, 1).getValueAsString()});
                    break;
                }
                case 2: {
                    object2 = Messages.getString("BoardView1.punchRight", new Object[]{PunchAttackAction.toHit(this.game, attackAction.getEntityId(), this.trg, 2).getValueAsString()});
                }
            }
        } else if (attackAction instanceof PushAttackAction) {
            object2 = Messages.getString("BoardView1.push", new Object[]{((PushAttackAction)attackAction).toHit(this.game).getValueAsString()});
        } else if (attackAction instanceof ClubAttackAction) {
            object2 = Messages.getString("BoardView1.hit", new Object[]{((ClubAttackAction)attackAction).getClub().getName(), ((ClubAttackAction)attackAction).toHit(this.game).getValueAsString()});
        } else if (attackAction instanceof ChargeAttackAction) {
            object2 = Messages.getString("BoardView1.charge", new Object[]{((ChargeAttackAction)attackAction).toHit(this.game).getValueAsString()});
        } else if (attackAction instanceof DfaAttackAction) {
            object2 = Messages.getString("BoardView1.DFA", new Object[]{((DfaAttackAction)attackAction).toHit(this.game).getValueAsString()});
        } else if (attackAction instanceof ProtomechPhysicalAttackAction) {
            object2 = Messages.getString("BoardView1.proto", new Object[]{((ProtomechPhysicalAttackAction)attackAction).toHit(this.game).getValueAsString()});
        } else if (attackAction instanceof SearchlightAttackAction) {
            object2 = Messages.getString("BoardView1.Searchlight");
        }
        object = new TransformGroup(new Transform3D(C.nullRot, this.labelLocation, 1.0));
        this.labelLocation.z += 3.0;
        this.labelLocation.y += 3.0;
        object.addChild(viewTransform.makeViewRelative((Node)new LabelModel((String)object2, C.black, this.color, LabelModel.BIGBOLD), 0.0));
        object.setUserData((Object)attackAction);
        this.addChild((Node)object);
    }
}

