;------------------------------ $Keywords ----------------------------------
; GPGee - GNU Privacy Guard Explorer Extension
; GPGee.nsi - Nullsoft Installer script
; Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
;---------------------------------------------------------------------------
; This file is part of GPGee.
;
; GPGee is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License (Version 2) as
; published by the Free Software Foundation.
;
; GPGee is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
;---------------------------------------------------------------------------
; VCS: $Version: 1 $ $Revision: 14 $
/*
$History: **** V 1.0 by kfitzner ****
$History: * gpgee.nsi - 2005-05-12 9:22:18 AM - 2965 Bytes
$History: * Initial check-in
$History: **** V 1.1 by kfitzner ****
$History: * gpgee.nsi - 2005-05-17 2:25:21 AM - 2961 Bytes
$History: * Version number increase for release (1.1.0)
$History: **** V 1.2 by kfitzner ****
$History: * gpgee.nsi - 2005-07-17 1:45:34 PM - 2961 Bytes
$History: * Update version number for release 1.1.1
$History: **** V 1.3 by kfitzner ****
$History: * gpgee.nsi - 2005-07-29 2:57:15 PM - 2961 Bytes
$History: * Changes for 1.1.2 release.
$History: **** V 1.4 by kfitzner ****
$History: * gpgee.nsi - 2005-08-08 7:57:55 AM - 4054 Bytes
$History: * Add copyright information and keywords
$History: **** V 1.5 by kfitzner ****
$History: * gpgee.nsi - 2005-08-08 8:02:09 AM - 4054 Bytes
$History: * Update version
$History: **** V 1.6 by kfitzner ****
$History: * gpgee.nsi - 2005-08-08 8:39:50 AM - 4950 Bytes
$History: * Change installer icon
$History: **** V 1.7 by kfitzner ****
$History: * gpgee.nsi - 2005-08-31 8:37:22 PM - 6039 Bytes
$History: * Add support for automatic updates
$History: **** V 1.8 by kfitzner ****
$History: * gpgee.nsi - 2005-09-06 3:23:30 AM - 6177 Bytes
$History: * Prepare for 1.2.0 release
$History: **** V 1.9 by kfitzner ****
$History: * gpgee.nsi - 2005-09-06 7:33:18 PM - 6306 Bytes
$History: * Update for 1.2.1
$History: **** V 1.10 by kfitzner ****
$History: * gpgee.nsi - 2005-10-06 8:23:03 PM - 6948 Bytes
$History: * Fix DLL overwrite error when upgrading
$History: **** V 1.11 by kfitzner ****
$History: * gpgee.nsi - 2005-10-06 8:29:09 PM - 7278 Bytes
$History: * Add German language module
$History: **** V 1.12 by kfitzner ****
$History: * gpgee.nsi - 2005-12-11 3:41:03 PM - 7407 Bytes
$History: * Update for 1.2.2
$History: **** V 1.13 by kfitzner ****
$History: * gpgee.nsi - 2005-12-12 3:13:06 PM - 7538 Bytes
$History: * Updarte for 1.2.3
$History: **** Latest ** V 1.14 by kfitzner ** 2006-01-13 9:09:32 AM ****
$History: * Update for 1.3.0
*/
;----------------------------  $NoKeywords ---------------------------------

!define PRODUCT_NAME "GPGee"
!define PRODUCT_VERSION "1.3.0"
!define PRODUCT_PUBLISHER "Kurt Fitzner"
!define PRODUCT_WEB_SITE "http://www.excelcia.org"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_KEY "Software\GPGee"
!define PRODUCT_ROOT_KEY "HKCU"
!define LIBRARY_SHELL_EXTENSION

SetCompressor lzma

!include "Library.nsh"
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "..\images\GPGee.ico"
!define MUI_UNICON "..\images\GPGee_Uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "gpl.txt"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Automatic updates page
Page custom AutoUpdatesPage
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; Reserve files
ReserveFile "GPGeeAutoUpdates.ini"
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

; Variables
Var AUTO_UPDATES

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "GPGeeSetup-${PRODUCT_VERSION}.exe"
InstallDir "$PROGRAMFILES\GPGee"
ShowInstDetails show
ShowUnInstDetails show

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "gpl.txt"
  File "..\help\GPGee.hlp"
  !insertmacro InstallLib REGDLL NOTSHARED REBOOT_NOTPROTECTED ..\GPGee.dll $INSTDIR\GPGee.dll $INSTDIR
  !insertmacro InstallLib REGDLL NOTSHARED REBOOT_NOTPROTECTED ..\GPGee.DEU $INSTDIR\GPGee.DEU $INSTDIR
  # $File "..\GPGee.dll"
  SetOutPath "$FONTS"
  File "VeraMoBd.ttf"
  File "VeraMoBI.ttf"
  File "VeraMoIt.ttf"
  File "VeraMono.ttf"
SectionEnd

Section -Post
  # RegDLL "$INSTDIR\GPGee.dll"
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
  !insertmacro MUI_INSTALLOPTIONS_READ $AUTO_UPDATES "GPGeeAutoUpdates.ini" "Field 2" "State"
  StrCmp $AUTO_UPDATES "1" "" +3
    WriteRegDWORD ${PRODUCT_ROOT_KEY} ${PRODUCT_KEY} "Update Notify" 1
    Goto +2
  WriteRegDWORD ${PRODUCT_ROOT_KEY} ${PRODUCT_KEY} "Update Notify" 0
SectionEnd

Function .onInit
  ;Extract InstallOptions INI files
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "GPGeeAutoUpdates.ini"
FunctionEnd

LangString TEXT_IO_TITLE ${LANG_ENGLISH} "Automatic Updates"
LangString TEXT_IO_SUBTITLE ${LANG_ENGLISH} "Choose your automatic updates setting:"

Function AutoUpdatesPage
  !insertmacro MUI_HEADER_TEXT "$(TEXT_IO_TITLE)" "$(TEXT_IO_SUBTITLE)"
  !insertmacro MUI_INSTALLOPTIONS_DISPLAY "GPGeeAutoUpdates.ini"
FunctionEnd

Function un.onUninstSuccess
  HideWindow
  IfRebootFlag 0 noreboot
    MessageBox MB_ICONQUESTION|MB_YESNO "Because $(ProductName) is currently in use by Windows, a reboot is required in order to complete the uninstall.  Do you want to reboot now?" IDNO noreboot
    Reboot
    Goto +3
  noreboot:
    MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  UnRegDLL "$INSTDIR\GPGee.dll"
  Delete "$INSTDIR\uninst.exe"
  Delete "$FONTS\VeraMono.ttf"
  Delete "$FONTS\VeraMoIt.ttf"
  Delete "$FONTS\VeraMoBI.ttf"
  Delete "$FONTS\VeraMoBd.ttf"
  Delete "$INSTDIR\gpl.txt"
  Delete "$INSTDIR\GPGee.hlp"
  Delete "$INSTDIR\GPGee.gid"
  !insertmacro UnInstallLib REGDLL NOTSHARED REBOOT_NOTPROTECTED $INSTDIR\GPGee.dll
  !insertmacro UnInstallLib REGDLL NOTSHARED REBOOT_NOTPROTECTED $INSTDIR\GPGee.DEU
  # Delete "$INSTDIR\GPGee.dll"

  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd
