//#ifdef GPGME_CPP_H
//#define GPGME_CPP_H

#ifdef WITH_CPP_WRAPPER

typedef enum {
    GPG_ERR_SUCCESS = 0,
    GPG_ERR_INV_VALUE = 1,
    GPG_ERR_INV_MODE = 2,
    GPG_ERR_PWD_NOT_SET = 3
};

class gpgme_key {
public:
    gpgme_key (gpgme_key_t key);
    ~gpgme_key ();
    int sign (int sigclass, int local);
    int trust (int val);
    int adduid (const char * name, const char * comment, const char * mail);
    int addkey (int algo);
    int addphoto (const char * file);
    int addrevoker (const char * name);
    int deluid (int id);
    int delkey (int id);
    int passwd (const char * old, const char * new_);
    int primary (const char * pwd);
    int expire (const char *isodate);
    int revkey (int id);
    int revoke (const char * pwd);
    int enable (const char * pwd);
    int disable (const char * pwd);
    int setpref (int id, const char * prefs);
    int set_passwd (const char * pwd);
    unsigned ulong_attr (int what, int idx);
    const char * string_attr (int what, int idx);
    const void * attrib_attr (int * nbytes);

private:
    gpgme_key_t key;
    gpgme_ctx_t ctx;
    gpgme_editkey_t edit_ctx;
    char * passphrase;
};

#endif /* WITH_CPP_WRAPPER */
//#endif /* GPGME_CPP_H */
