# ----------------------------------------------------------------------------
# $Id: acinclude.m4,v 1.9 2003/01/07 12:27:01 raif Exp $
#
# Copyright (C) 2001, 2002, Free Software Foundation, Inc.
#
# This file is part of GNU Crypto.
#
# GNU Crypto is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# GNU Crypto is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to the
#
#    Free Software Foundation Inc.,
#    59 Temple Place - Suite 330,
#    Boston, MA 02111-1307
#    USA
#
# Linking this library statically or dynamically with other modules is
# making a combined work based on this library.  Thus, the terms and
# conditions of the GNU General Public License cover the whole
# combination.
#
# As a special exception, the copyright holders of this library give
# you permission to link this library with independent modules to
# produce an executable, regardless of the license terms of these
# independent modules, and to copy and distribute the resulting
# executable under terms of your choice, provided that you also meet,
# for each linked independent module, the terms and conditions of the
# license of that module.  An independent module is a module which is
# not derived from or based on this library.  If you modify this
# library, you may extend this exception to your version of the
# library, but you are not obligated to do so.  If you do not wish to
# do so, delete this exception statement from your version.
# ----------------------------------------------------------------------------
#
# GNU Crypto m4 macros for auto-configuration
#
# This file is an input to aclocal which generates aclocal.m4, which in turn,
# is an input to autoconf which generates the ./configure script.
#
# $Revision: 1.9 $
#

# process --with-java configure option.
# test if a Java bytecode interpreter is available, and if yes set in
# JAVA_BIN_PATH the path to the executable, and in
# JAVA_RT_JAR   the path to the runtime jar (needed by jikes and similar).
# -----------------------------------------------------------------------------
AC_DEFUN([_GNU_CRYPTO_WHICH_JAVA],[
AC_ARG_WITH([java],
            AC_HELP_STRING([--with-java@<:@=ARG@:>@],
                           [use Java for bytecode interpretation, and optionally the path where to find it]),
            [if test "x${withval}" != x && test "x${withval}" != xyes && test "x${withval}" != xno; then
              _GNU_CRYPTO_CHECK_JAVA(${withval})
            elif test "x${withval}" != xno; then
              _GNU_CRYPTO_CHECK_JAVA
            fi],
            [_GNU_CRYPTO_CHECK_JAVA])
AM_CONDITIONAL(FOUND_JAVA, test "x${JAVA}" != x)
AC_SUBST(JAVA)
JAVA_BIN_PATH=`AS_DIRNAME([$JAVA])`
if test -r ${JAVA_BIN_PATH}/../jre/lib/rt.jar ; then
  JAVA_RT_JAR=${JAVA_BIN_PATH}/../jre/lib/rt.jar
  AC_SUBST(JAVA_RT_JAR)
fi
AC_SUBST(JAVA_BIN_PATH)
])# _GNU_CRYPTO_WHICH_JAVA


# a wrapper around AC_PATH_PROG to check for the accessibility of a Java
# bytecode interpreter.
# may be invoked without or with one argument.  when invoked with no arguments
# the executable 'java' (supposedly accessible from PATH directories) is used
# as the argument to AC_PATH_PROG.
# if the Java bytecode interpreter is found, this macro checks the version of
# that interpreter, in order to set the conditional WITH_BREAKITERATOR which
# needed to specify correct parameters to the 'javadoc' tool.  this assumes
# (a) the bytecode interpreter is the sun's one, or (b) the substitute tools
# closely mimic sun's tools behaviour.
# -----------------------------------------------------------------------------
AC_DEFUN([_GNU_CRYPTO_CHECK_JAVA],[
if test "x$1" != x; then
  if test -f "$1"; then
    JAVA="$1"
  else
    AC_PATH_PROG(JAVA, "$1")
  fi
else
  AC_PATH_PROG(JAVA, "java")
fi

if test "x$JAVA" != x; then
  AC_MSG_CHECKING(for java version)
  JAVA_VERSION=`$JAVA -version  2>&1 | head -1 | cut -d '"' -f 2`
  JAVA_VERSION_MAJOR=`echo $JAVA_VERSION | cut -d '.' -f 1`
  JAVA_VERSION_MINOR=`echo $JAVA_VERSION | cut -d '.' -f 2`
  AC_MSG_RESULT($JAVA_VERSION)

  AC_MSG_CHECKING(wether javadoc uses -breakiterator)
  if (expr "$JAVA_VERSION_MAJOR" \> 0 >/dev/null ) && (expr "$JAVA_VERSION_MINOR" \> 3 >/dev/null); then
    AC_MSG_RESULT([yes])
  else
    AC_MSG_RESULT([no])
  fi
fi
AM_CONDITIONAL(WITH_BREAKITERATOR, (expr "$JAVA_VERSION_MAJOR" \> 0 >/dev/null) && (expr "$JAVA_VERSION_MINOR" \> 3 >/dev/null))[]dnl
])# _GNU_CRYPTO_CHECK_JAVA

# =============================================================================

# process --with-classpath configure option.
# test if the GNU Classpath package is installed.  if no argument was specified
# with the option, this macro looks for a 'share/classpath/glibj.zip' file and
# a 'lib/classpath/libjavalang.so' in the following places, in this order:
# /usr/local/classpath, /usr/local, /usr, /opt/classpath, and /opt.  otherwise
# those two files are looked up under the designated location.
# if glibj.zip is found, GLIBJ_ZIP shall contain its path.
# -----------------------------------------------------------------------------
AC_DEFUN([_GNU_CRYPTO_WITH_CLASSPATH],[
AC_ARG_WITH([classpath],
            AC_HELP_STRING([--with-classpath],
                           [path to GNU Classpath install directory.  if unspecified, /usr/local/classpath, /usr/local, /usr, /opt/classpath, and /opt are considered, in that order]),

            [if test "x${withval}" != x && test "x${withval}" != xyes && test "x${withval}" != xno; then
              AC_MSG_CHECKING([${withval}])
              _GNU_CRYPTO_CHECK_CLASSPATH(${withval})
              if test x$GNU_CLASSPATH_INSTALL_DIR = x ; then
                AC_MSG_RESULT(no)
                AC_MSG_ERROR([cannot find designated GNU Classpath install directory])
              else
                AC_MSG_RESULT(yes)
                with_classpath=true
              fi
            elif test "x${withval}" != xno; then
              AC_MSG_NOTICE([no value supplied --with-classpath.  will look in default locations])
              _GNU_CRYPTO_FIND_GNU_CLASSPATH([/usr/local/classpath /usr/local /usr /opt/classpath /opt])
              if test x$GNU_CLASSPATH_INSTALL_DIR = x ; then
                AC_MSG_ERROR([cannot find GNU Classpath install directory: install it and/or specify its location using --with-classpath])
              fi
              with_classpath=true
            else
              with_classpath=false
            fi],
            [with_classpath=false])
GNU_CLASSPATH_INSTALL_DIR=`(cd ${GNU_CLASSPATH_INSTALL_DIR}; pwd)`
AC_SUBST(GNU_CLASSPATH_INSTALL_DIR)
if test -r ${GNU_CLASSPATH_INSTALL_DIR}/share/classpath/glibj.zip ; then
  GLIBJ_ZIP=${GNU_CLASSPATH_INSTALL_DIR}/share/classpath/glibj.zip
  AC_SUBST(GLIBJ_ZIP)
fi
AM_CONDITIONAL(USER_WANT_CLASSPATH, test "x${with_classpath}" = xtrue)
])# _GNU_CRYPTO_WITH_CLASSPATH


# given a list of arguments, this macro tries repeatedly and for each element
# of the input list, to (a) assert that the argument is indeed a directory, and
# (b) it contains under it both 'lib/classpath/libjavalang.so' and
# 'share/classpath/glibj.zip' files.
# -----------------------------------------------------------------------------
AC_DEFUN(_GNU_CRYPTO_FIND_GNU_CLASSPATH,[
AC_MSG_CHECKING([for GNU Classpath installation directory])
for _F in $1 ; do
  _GNU_CRYPTO_CHECK_CLASSPATH(${_F})
  if test x$GNU_CLASSPATH_INSTALL_DIR != x ; then
    break
  fi
done
if test x${GNU_CLASSPATH_INSTALL_DIR} = x ; then
  AC_MSG_RESULT([not found])
else
  AC_MSG_RESULT([${GNU_CLASSPATH_INSTALL_DIR}])
fi])# _GNU_CRYPTO_FIND_GNU_CLASSPATH


# given a directory as an input, this macro checks if the two files
# 'lib/classpath/libjavalang.so' and 'share/classpath/glibj.zip' exist under
# it.  if they do, then GNU_CLASSPATH_INSTALL_DIR is set to that argument.
# -----------------------------------------------------------------------------
AC_DEFUN([_GNU_CRYPTO_CHECK_CLASSPATH],
[if test -r $1/lib/classpath/libjavalang.so && test -r $1/share/classpath/glibj.zip ; then
  GNU_CLASSPATH_INSTALL_DIR=$1
fi])# _GNU_CRYPTO_CHECK_CLASSPATH

# =============================================================================

# check user preferences for the bytecode compiler to use.
# user preferences may be defined with --with-xxx style configure options.
# those of interest to this macro are:
#
#    --with-gcj=...
#    --with-jikes=...
#    --with-javac=...
#
# each of the above options may be (a) empty, (b) equal to 'yes' or 'no', or
# (c) points to the location of the executable of that compiler.
# when the option is specified with no value, default locations are searched
# for the executable to ensure they can be used.  if more than one are
# specified, GCJ is picked before Jikes, which is picked before Javac.
# the first thing this macro does is invoke the _GNU_CRYPTO_WHICH JAVA and the
# _GNU_CRYPTO_WITH_CLASSPATH macros.  this is to ensure that a proper runtime
# jar can be used if the chosen compiler needs it.
# it then checks the arguments for each option in turn, setting a USER_WANT_xxx
# if a positive definition of the corresponding --with-xxx was specified.
# finally the USE_xxx conditionals are set if configure is able to locate the
# appropriate binary.
# -----------------------------------------------------------------------------
AC_DEFUN([GNU_CRYPTO_WHICH_JAVAC],[
_GNU_CRYPTO_WHICH_JAVA
_GNU_CRYPTO_WITH_CLASSPATH

user_specified_compiler=_GNU_CRYPTO_WITH_GCJ _GNU_CRYPTO_WITH_JIKES _GNU_CRYPTO_WITH_JAVAC

AM_CONDITIONAL(USER_WANT_GCJ,   test "x${user_specified_compiler}" = xgcj)
AM_CONDITIONAL(USER_WANT_JIKES, test "x${user_specified_compiler}" = xjikes)
AM_CONDITIONAL(USER_WANT_JAVAC, test "x${user_specified_compiler}" = xjavac)

# sanity check
_GNU_CRYPTO_ENSURE_GCJ
AM_CONDITIONAL(USE_GCJ,   test "x${selected_compiler}" = xgcj)
AM_CONDITIONAL(USE_JIKES, test "x${selected_compiler}" = xjikes)
AM_CONDITIONAL(USE_JAVAC, test "x${selected_compiler}" = xjavac)

AM_CONDITIONAL(FOUND_GCJ,   test "x${GCJ}" != x)
AM_CONDITIONAL(FOUND_JIKES, test "x${JIKES}" != x)
AM_CONDITIONAL(FOUND_JAVAC, test "x${JAVAC}" != x)
])# _GNU_CRYPTO_WHICH_JAVAC


AC_DEFUN([_GNU_CRYPTO_ENSURE_GCJ],[
if test "x${user_specified_compiler}" = xgcj || test "x${user_specified_compiler}" = x ; then
  if test "x${GCJ}" != x; then
    AC_MSG_NOTICE([will use GCJ for bytecode compilation])
    selected_compiler=gcj
  else
    AC_MSG_NOTICE([GCJ specified but not found.  Will try with Jikes])
    user_specified_compiler=jikes
    _GNU_CRYPTO_ENSURE_JIKES
  fi
else
  _GNU_CRYPTO_ENSURE_JIKES
fi])# _GNU_CRYPTO_ENSURE_GCJ


AC_DEFUN([_GNU_CRYPTO_ENSURE_JIKES],[
if test "x${user_specified_compiler}" = xjikes; then
  if test "x${JIKES}" != x; then
    # cannot use jikes without either glibj.zip or rt.jar
    if test "x${GLIBJ_ZIP}" != x || test "x${JAVA_RT_JAR}" != x; then
      AC_MSG_NOTICE([will use Jikes for bytecode compilation])
      selected_compiler=jikes
    else
      AC_MSG_NOTICE([Jikes specified but runtime classes not found.  Will try with Javac])
      _GNU_CRYPTO_ENSURE_JAVAC
    fi
  else
    AC_MSG_NOTICE([Jikes specified but not found.  Will try with Javac])
    _GNU_CRYPTO_ENSURE_JAVAC
  fi
else
  _GNU_CRYPTO_ENSURE_JAVAC
fi])# GNU_CRYPTO_ENSURE_JIKES


AC_DEFUN([_GNU_CRYPTO_ENSURE_JAVAC],[
if test "x${JAVAC}" != x; then
  AC_MSG_NOTICE([will use Javac for bytecode compilation])
  selected_compiler=javac
else # user wants nothing; back-track
  if test "x${GCJ}" != x; then
    AC_MSG_NOTICE([will use GCJ for bytecode compilation])
    selected_compiler=gcj
  else
    if test "x${JIKES}" != x; then
      # cannot use jikes without either glibj.zip or rt.jar
      if test "x${GLIBJ_ZIP}" != x || test "x${JAVA_RT_JAR}" != x; then
        AC_MSG_NOTICE([will use Jikes for bytecode compilation])
        selected_compiler=jikes
      else
        AC_MSG_NOTICE([cannot find a runtime library for use with Jikes])
        _GNU_CRYPTO_NO_COMPILER
      fi
    else
      _GNU_CRYPTO_NO_COMPILER
    fi
  fi
fi])# _GNU_CRYPTO_ENSURE_JAVAC


AC_DEFUN([_GNU_CRYPTO_NO_COMPILER],[
AC_MSG_NOTICE([cannot find a suitable java bytecode compiler])
AC_MSG_ERROR([try --with-gcj[[=ARG]], --with-jikes[[=ARG]], or --with-javac[[=ARG]]], 1)
])# _GNU_CRYPTO_NO_COMPILER


AC_DEFUN([_GNU_CRYPTO_WITH_GCJ],[
AC_ARG_WITH([gcj],
            AC_HELP_STRING([--with-gcj@<:@=ARG@:>@],
                           [use GCJ for bytecode compilation, and optionally the path where to find it @<:@ARG=yes@:>@]),
            [if test "x${withval}" != x && test "x${withval}" != xyes && test "x${withval}" != xno; then
              user_specified_compiler=gcj
              _GNU_CRYPTO_CHECK_GCJ(${withval})
            elif test "x${withval}" != xno; then
              user_specified_compiler=gcj
              _GNU_CRYPTO_CHECK_GCJ
            else
              user_specified_compiler=
            fi],
            [_GNU_CRYPTO_CHECK_GCJ])
AM_CONDITIONAL(FOUND_GCJ, test "x${GCJ}" != x)
AC_SUBST(GCJ)
])# _GNU_CRYPTO_WITH_GCJ


AC_DEFUN([_GNU_CRYPTO_CHECK_GCJ],[
if test "x$1" != x; then
  if test -f "$1"; then
    GCJ="$1"
  else
    AC_PATH_PROG(GCJ, "$1")
  fi
else
  AC_PATH_PROG(GCJ, "gcj")
fi
if test "x$GCJ" != x; then
  AC_MSG_CHECKING(gcj version)
  GCJ_VERSION=`$GCJ --version`
  GCJ_VERSION_MAJOR=`echo "$GCJ_VERSION" | cut -d '.' -f 1`
  GCJ_VERSION_MINOR=`echo "$GCJ_VERSION" | cut -d '.' -f 2`
  if expr "$GCJ_VERSION_MAJOR" \< 3 > /dev/null; then
    GCJ=""
  fi
  if expr "$GCJ_VERSION_MAJOR" = 3 > /dev/null; then
    if expr "$GCJ_VERSION_MINOR" \< 1; then
      GCJ=""
    fi
  fi
  if test "x$GCJ" != x; then
    AC_MSG_RESULT($GCJ_VERSION)
    AM_PROG_GCJ
  else
    AC_MSG_WARN($GCJ_VERSION: gcj 3.1 or higher required)
  fi
fi])# _GNU_CRYPTO_CHECK_GCJ


AC_DEFUN([_GNU_CRYPTO_WITH_JIKES],[
AC_ARG_WITH([jikes],
            AC_HELP_STRING([--with-jikes@<:@=ARG@:>@],
                           [use Jikes for bytecode compilation, and optionally the path where to find it @<:@ARG=no@:>@]),
            [if test "x${withval}" != x && test "x${withval}" != xyes && test "x${withval}" != xno; then
              user_specified_compiler=jikes
              _GNU_CRYPTO_CHECK_JIKES(${withval})
            elif test "x${withval}" != xno; then
              user_specified_compiler=jikes
              _GNU_CRYPTO_CHECK_JIKES
            else
              user_specified_compiler=
            fi],
            [_GNU_CRYPTO_CHECK_JIKES])
AM_CONDITIONAL(FOUND_JIKES, test "x${JIKES}" != x)
AC_SUBST(JIKES)
])# _GNU_CRYPTO_WITH_JIKES


AC_DEFUN([_GNU_CRYPTO_CHECK_JIKES],[
if test "x$1" != x; then
  if test -f "$1"; then
    JIKES="$1"
  else
    AC_PATH_PROG(JIKES, "$1")
  fi
else
  AC_PATH_PROG(JIKES, "jikes")
fi])# _GNU_CRYPTO_CHECK_JIKES


AC_DEFUN([_GNU_CRYPTO_WITH_JAVAC],[
AC_ARG_WITH([javac],
            AC_HELP_STRING([--with-javac@<:@=ARG@:>@],
                           [use Javac for bytecode compilation, and optionally the path where to find it @<:@ARG=no@:>@]),
            [if test "x${withval}" != x && test "x${withval}" != xyes && test "x${withval}" != xno; then
              user_specified_compiler=javac
              _GNU_CRYPTO_CHECK_JAVAC(${withval})
            elif test "x${withval}" != xno; then
              user_specified_compiler=javac
              _GNU_CRYPTO_CHECK_JAVAC
            else
              user_specified_compiler=
            fi],
            [_GNU_CRYPTO_CHECK_JAVAC])
AM_CONDITIONAL(FOUND_JAVAC, test "x${JAVAC}" != x)
AC_SUBST(JAVAC)
])# _GNU_CRYPTO_WITH_JAVAC


AC_DEFUN([_GNU_CRYPTO_CHECK_JAVAC],[
if test "x$1" != x; then
  if test -f "$1"; then
    JAVAC="$1"
  else
    AC_PATH_PROG(JAVAC, "$1")
  fi
else
  AC_PATH_PROG(JAVAC, "javac")
fi])# _GNU_CRYPTO_CHECK_JAVAC

# =============================================================================

AC_DEFUN([_GNU_CRYPTO_WITH_JCE_JAR],[
AC_ARG_WITH([jce_jar],
            AC_HELP_STRING([--with-jce-jar=DIR],
                           [path to JCE framework classes (javax.crypto) jar.  if unspecified, /usr/local/jce/share, /usr/local/share, /usr/share, /opt/jce/share, and /opt/share are considered, in that order; unless --with-jce is specified]),
            [if test "x${withval}" != x && test "x${withval}" != xyes && test "x${withval}" != xno; then
              AC_MSG_CHECKING([for ${withval}])
              if test -r ${withval} ; then
                AC_MSG_RESULT(yes)
                JCE_JAR=${withval}
                found_jce_jar=true
              else
                AC_MSG_ERROR([cannot find indicated JCE jar])
              fi
            elif test "x${withval}" != xno; then
              AC_MSG_NOTICE([no value supplied --with-jce-jar.  will look in default locations])
              _GNU_CRYPTO_FIND_JCE_JAR([/usr/local/jce /usr/local /usr /opt/jce /opt])
              if test x$JCE_JAR = x ; then
                AC_MSG_ERROR([cannot find JCE jar; specify its location using --with-jce-jar])
              fi
              INCLUDE_FOR_MAUVE_JCE=""
              found_jce_jar=true
            else
              JCE_JAR=""
              INCLUDE_FOR_MAUVE_JCE="!"
              found_jce_jar=false
            fi],
            [JCE_JAR=""
             INCLUDE_FOR_MAUVE_JCE="!"
             found_jce_jar=false])
AM_CONDITIONAL(FOUND_JCE_JAR, test "x${found_jce_jar}" = xtrue)
AC_SUBST(JCE_JAR)
AC_SUBST(INCLUDE_FOR_MAUVE_JCE)
])# _GNU_CRYPTO_WITH_JCE_JAR


AC_DEFUN(_GNU_CRYPTO_FIND_JCE_JAR,[
AC_MSG_CHECKING([for JCE jar])
for _F in $1 ; do
  _GNU_CRYPTO_CHECK_JCE_JAR(${_F})
  if test x$JCE_JAR != x ; then
    break
  fi
done
if test x${JCE_JAR} = x ; then
  AC_MSG_RESULT([not found])
else
  AC_MSG_RESULT([${JCE_JAR}])
fi])# _GNU_CRYPTO_FIND_JCE_JAR


AC_DEFUN([_GNU_CRYPTO_CHECK_JCE_JAR],
[if test -r $1/share/javax-crypto.jar ; then
  JCE_JAR=$1/share/javax-crypto.jar
fi])# _GNU_CRYPTO_CHECK_JCE_JAR


# macros copied from Mauve project's configure.in and acinclude.m4
# -----------------------------------------------------------------------------

# Designate the temporary directory to use by Mauve
AC_DEFUN(GNU_CRYPTO_WITH_TMPDIR,[
AC_ARG_WITH([tmpdir],
            AC_HELP_STRING([--with-tmpdir=DIR],
                           [put temporary files in DIR @<:@/tmp@:>@]),
            TMPDIR="$with_tmpdir",
            TMPDIR=/tmp)
AC_SUBST(TMPDIR)
])# GNU_CRYPTO_WITH_TMPDIR


# -----------------------------------------------------------
# Original by Mark Elbrecht <snowball3@bigfoot.com>
# Modified by Brian Jones <cbj@gnu.org> for Mauve
# acx_check_pathname_style.m4
# http://research.cys.de/autoconf-archive/

AC_DEFUN(ACX_CHECK_PATHNAME_STYLE_DOS,[
AC_MSG_CHECKING([for Windows and DOS and OS/2 style pathnames])
AC_CACHE_VAL([acx_cv_pathname_style_dos],[
             AC_REQUIRE([AC_CANONICAL_HOST])
             acx_cv_pathname_style_dos="no"
             case ${host_os} in
               *djgpp | *mingw32* | *emx*) acx_cv_pathname_style_dos="yes" ;;
             esac])
AC_MSG_RESULT([$acx_cv_pathname_style_dos])
if test "$acx_cv_pathname_style_dos" = "yes"; then
  AC_DEFINE([HAVE_PATHNAME_STYLE_DOS],[],[defined if running on a system with dos style paths])
  CHECK_PATH_SEPARATOR=';'
  CHECK_FILE_SEPARATOR='\\'
else
  CHECK_PATH_SEPARATOR=':'
  CHECK_FILE_SEPARATOR='/'
fi
AC_SUBST(CHECK_PATH_SEPARATOR)
AC_SUBST(CHECK_FILE_SEPARATOR)
])

# =============================================================================

AC_DEFUN([GNU_CRYPTO_WITH_JCE],[
AC_ARG_WITH([jce],
            AC_HELP_STRING([--with-jce@<:@=ARG@:>@ ],
                           [build the Java Cryptography Extension (JCE) as a shared library @<:@ARG=yes@:>@.  If this option is specified then --with-jce-jar is ignored]),
            [case "${withval}" in
              yes) with_jce=yes ;;
              no)  with_jce=no ;;
              *)   AC_MSG_ERROR([bad value ${withval} for --with-jce]) ;;
            esac],
            [with_jce=yes])
AM_CONDITIONAL(WITH_JCE, test "x${with_jce}" = xyes)
if test "x${with_jce}" = xyes; then
  JCE_JAR="`pwd`/jce/javax-crypto.jar"
  INCLUDE_FOR_MAUVE_JCE=""
  found_jce_jar=true

  AM_CONDITIONAL(FOUND_JCE_JAR, test "x${found_jce_jar}" = xtrue)
  AC_SUBST(JCE_JAR)
  AC_SUBST(INCLUDE_FOR_MAUVE_JCE)
else
  _GNU_CRYPTO_WITH_JCE_JAR
fi])# GNU_CRYPTO_WITH_JCE