/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.tool;

import gnu.crypto.cipher.CipherFactory;
import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.util.Util;
import java.security.InvalidKeyException;
import java.util.HashMap;

public class NistMCT {
    private String cipherName;
    private int keySize;
    private IBlockCipher cipher;
    private long encBlocks;
    private long decBlocks;
    private long keyCount;

    private NistMCT(String cipherName, IBlockCipher cipher, int keySize) {
        this.cipherName = cipherName;
        this.cipher = cipher;
        this.keySize = keySize;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            NistMCT.printUsage();
            return;
        }
        try {
            doECB = false;
            doCBC = false;
            doEnc = false;
            doDec = false;
            cipherName = null;
            kSize = null;
            i = 0;
            while (i < args.length) {
                arg = args[i];
                if (!arg.startsWith("-")) ** GOTO lbl-1000
                option = arg.substring(1);
                if (option.equals("E")) {
                    doECB = true;
                } else if (option.equals("C")) {
                    doCBC = true;
                } else if (option.equals("A")) {
                    doECB = true;
                    doCBC = true;
                } else if (option.equals("e")) {
                    doEnc = true;
                } else if (option.equals("d")) {
                    doDec = true;
                } else if (option.equals("a")) {
                    doEnc = true;
                    doDec = true;
                } else if (option.equals("h")) {
                    NistMCT.printUsage();
                } else if (cipherName == null) {
                    cipherName = args[i];
                } else if (kSize == null) {
                    kSize = args[i];
                    break;
                }
                ++i;
            }
            if (!doECB && !doCBC) {
                doECB = true;
                doCBC = true;
            }
            if (!doEnc && !doDec) {
                doEnc = true;
                doDec = true;
            }
            if (cipherName == null) {
                System.err.println("Missing cipher name...");
                NistMCT.printUsage();
                return;
            }
            cipher = CipherFactory.getInstance(cipherName);
            time = -System.currentTimeMillis();
            cmd = kSize == null ? new NistMCT[]{new NistMCT(cipherName, cipher, 128), new NistMCT(cipherName, cipher, 192), new NistMCT(cipherName, cipher, 256)} : new NistMCT[]{new NistMCT(cipherName, cipher, Integer.parseInt(kSize))};
            if (doECB) {
                if (doEnc) {
                    System.out.println();
                    System.out.println("=========================");
                    System.out.println();
                    System.out.println("Electronic Codebook (ECB) Mode - ENCRYPTION");
                    System.out.println("Monte Carlo Test");
                    System.out.println();
                    System.out.println("Algorithm Name: " + String.valueOf(cipherName));
                    System.out.println();
                    System.out.println("==========");
                    i = 0;
                    while (i < cmd.length) {
                        cmd[i].ecbEncrypt();
                        ++i;
                    }
                }
                if (doDec) {
                    System.out.println();
                    System.out.println("=========================");
                    System.out.println();
                    System.out.println("Electronic Codebook (ECB) Mode - DECRYPTION");
                    System.out.println("Monte Carlo Test");
                    System.out.println();
                    System.out.println("Algorithm Name: " + String.valueOf(cipherName));
                    System.out.println();
                    System.out.println("==========");
                    i = 0;
                    while (i < cmd.length) {
                        cmd[i].ecbDecrypt();
                        ++i;
                    }
                }
            }
            if (doCBC) {
                if (doEnc) {
                    System.out.println();
                    System.out.println("=========================");
                    System.out.println();
                    System.out.println("Cipher Block Chaining (CBC) Mode - ENCRYPTION");
                    System.out.println("Monte Carlo Test");
                    System.out.println();
                    System.out.println("Algorithm Name: " + String.valueOf(cipherName));
                    System.out.println();
                    System.out.println("==========");
                    i = 0;
                    while (i < cmd.length) {
                        cmd[i].cbcEncrypt();
                        ++i;
                    }
                }
                if (doDec) {
                    System.out.println();
                    System.out.println("=========================");
                    System.out.println();
                    System.out.println("Cipher Block Chaining (CBC) Mode - DECRYPTION");
                    System.out.println("Monte Carlo Test");
                    System.out.println();
                    System.out.println("Algorithm Name: " + String.valueOf(cipherName));
                    System.out.println();
                    System.out.println("==========");
                    i = 0;
                    while (i < cmd.length) {
                        cmd[i].cbcDecrypt();
                        ++i;
                    }
                }
            }
            time += System.currentTimeMillis();
            encryptions = 0L;
            decryptions = 0L;
            keySetups = 0L;
            i = 0;
            while (i < cmd.length) {
                encryptions += cmd[i].encBlocks;
                decryptions += cmd[i].decBlocks;
                keySetups += cmd[i].keyCount;
                ++i;
            }
            System.out.println();
            System.out.println("Total execution time (ms): " + String.valueOf(time));
            System.out.println("During this time, " + String.valueOf(cipherName) + ":");
            System.out.println("  Encrypted " + String.valueOf(encryptions) + " blocks");
            System.out.println("  Decrypted " + String.valueOf(decryptions) + " blocks");
            System.out.println("  Created " + String.valueOf(keySetups) + " session keys");
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
        }
    }

    private static final void printUsage() {
        System.err.println();
        System.err.println("Usage:");
        System.err.println("   gnu.crypto.tool.NistKat (options) cipher [key-size]");
        System.err.println();
        System.err.println("Where:");
        System.err.println("   cipher");
        System.err.println("      The canonical name of the cipher algorithm.");
        System.err.println("   key-size");
        System.err.println("      The key-size in bits to use for the algorithm.  If unspecified,");
        System.err.println("      then the three NIST key-sizes 128, 192 and 256 shall be used.");
        System.err.println();
        System.err.println("Options:");
        System.err.println("   -E | -C | -A");
        System.err.println("      Generate Monte Carlo Test (MCT) data for ECB mode only, CBC mode");
        System.err.println("      only, or both.  For backward compatibility, if this option is ");
        System.err.println("      unspecified, then -A (both modes) is activated.");
        System.err.println("   -e | -d | -a");
        System.err.println("      Generate Monte Carlo Test (MCT) data for a designated cipher in");
        System.err.println("      the selected mode(s), for Encryption only, Decryption only, or");
        System.err.println("      both.  For backward compatibility, if this option is unspecified,");
        System.err.println("      then -a (both states) is activated.");
        System.err.println("   -h");
        System.err.println("      Print this help page.");
        System.err.println();
    }

    private void ecb() throws InvalidKeyException {
        this.ecbEncrypt();
        this.ecbDecrypt();
    }

    private void ecbEncrypt() throws InvalidKeyException {
        int keylen = this.keySize / 8;
        byte[] keyMaterial = new byte[keylen];
        int size = this.cipher.defaultBlockSize();
        byte[] pt = new byte[size];
        byte[] cpt = new byte[size];
        byte[] ct = new byte[size];
        byte[] ct_1 = new byte[size];
        System.out.println();
        System.out.println("KEYSIZE=" + String.valueOf(this.keySize));
        System.out.println();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        int i = 0;
        while (i < 400) {
            int k;
            System.out.println("I=" + String.valueOf(i));
            System.out.println("KEY=" + Util.toString(keyMaterial));
            System.out.println("PT=" + Util.toString(pt));
            map.put("gnu.crypto.cipher.key.material", keyMaterial);
            this.cipher.init(map);
            ++this.keyCount;
            this.cipher.encryptBlock(pt, 0, ct_1, 0);
            ++this.encBlocks;
            int j = 1;
            while (j < 9999) {
                this.cipher.encryptBlock(ct_1, 0, ct_1, 0);
                ++this.encBlocks;
                ++j;
            }
            this.cipher.encryptBlock(ct_1, 0, ct, 0);
            ++this.encBlocks;
            System.out.println("CT=" + Util.toString(ct));
            this.cipher.decryptBlock(ct, 0, cpt, 0);
            ++this.decBlocks;
            j = 1;
            while (j < 10000) {
                this.cipher.decryptBlock(cpt, 0, cpt, 0);
                ++this.decBlocks;
                ++j;
            }
            if (!Util.areEqual(pt, cpt)) {
                System.out.println(" *** ERROR ***");
                throw new RuntimeException("ECB Encryption/Decryption mismatch");
            }
            System.out.println();
            this.cipher.reset();
            j = 0;
            if (keylen > size) {
                int count = keylen - size;
                k = size - count;
                while (j < count) {
                    int n = j++;
                    keyMaterial[n] = (byte)(keyMaterial[n] ^ ct_1[k++]);
                }
            }
            k = 0;
            while (j < keylen) {
                int n = j++;
                keyMaterial[n] = (byte)(keyMaterial[n] ^ ct[k++]);
            }
            System.arraycopy(ct, 0, pt, 0, size);
            ++i;
        }
        System.out.println("==========");
    }

    void ecbDecrypt() throws InvalidKeyException {
        int keylen = this.keySize / 8;
        byte[] keyMaterial = new byte[keylen];
        int size = this.cipher.defaultBlockSize();
        byte[] pt = new byte[size];
        byte[] cpt = new byte[size];
        byte[] ct = new byte[size];
        byte[] ct_1 = new byte[size];
        System.out.println();
        System.out.println("KEYSIZE=" + String.valueOf(this.keySize));
        System.out.println();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        int i = 0;
        while (i < 400) {
            int k;
            map.put("gnu.crypto.cipher.key.material", keyMaterial);
            this.cipher.init(map);
            ++this.keyCount;
            this.cipher.encryptBlock(pt, 0, ct_1, 0);
            ++this.encBlocks;
            int j = 1;
            while (j < 9999) {
                this.cipher.encryptBlock(ct_1, 0, ct_1, 0);
                ++this.encBlocks;
                ++j;
            }
            this.cipher.encryptBlock(ct_1, 0, ct, 0);
            ++this.encBlocks;
            System.out.println("I=" + String.valueOf(i));
            System.out.println("KEY=" + Util.toString(keyMaterial));
            System.out.println("CT=" + Util.toString(ct));
            this.cipher.decryptBlock(ct, 0, cpt, 0);
            ++this.decBlocks;
            j = 1;
            while (j < 10000) {
                this.cipher.decryptBlock(cpt, 0, cpt, 0);
                ++this.decBlocks;
                ++j;
            }
            System.out.println("PT=" + Util.toString(cpt));
            if (!Util.areEqual(pt, cpt)) {
                System.out.println(" *** ERROR ***");
                throw new RuntimeException("ECB Encryption/Decryption mismatch");
            }
            System.out.println();
            this.cipher.reset();
            j = 0;
            if (keylen > size) {
                int count = keylen - size;
                k = size - count;
                while (j < count) {
                    int n = j++;
                    keyMaterial[n] = (byte)(keyMaterial[n] ^ ct_1[k++]);
                }
            }
            k = 0;
            while (j < keylen) {
                int n = j++;
                keyMaterial[n] = (byte)(keyMaterial[n] ^ ct[k++]);
            }
            System.arraycopy(ct, 0, pt, 0, size);
            ++i;
        }
        System.out.println("==========");
    }

    void cbc() throws InvalidKeyException {
        this.cbcEncrypt();
        this.cbcDecrypt();
    }

    void cbcEncrypt() throws InvalidKeyException {
        int keylen = this.keySize / 8;
        byte[] keyMaterial = new byte[keylen];
        int size = this.cipher.defaultBlockSize();
        byte[] pt = new byte[size];
        byte[] ct = new byte[size];
        byte[] iv = new byte[size];
        System.out.println();
        System.out.println("KEYSIZE=" + String.valueOf(this.keySize));
        System.out.println();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        int i = 0;
        while (i < 400) {
            int k;
            System.out.println("I=" + String.valueOf(i));
            System.out.println("KEY=" + Util.toString(keyMaterial));
            System.out.println("IV=" + Util.toString(iv));
            System.out.println("PT=" + Util.toString(pt));
            map.put("gnu.crypto.cipher.key.material", keyMaterial);
            this.cipher.init(map);
            ++this.keyCount;
            int j = 0;
            while (j < 10000) {
                k = 0;
                while (k < size) {
                    int n = k;
                    iv[n] = (byte)(iv[n] ^ pt[k]);
                    ++k;
                }
                System.arraycopy(ct, 0, pt, 0, size);
                this.cipher.encryptBlock(iv, 0, ct, 0);
                ++this.encBlocks;
                System.arraycopy(ct, 0, iv, 0, size);
                ++j;
            }
            System.out.println("CT=" + Util.toString(ct));
            System.out.println();
            this.cipher.reset();
            j = 0;
            if (keylen > size) {
                int count = keylen - size;
                k = size - count;
                while (j < count) {
                    int n = j++;
                    keyMaterial[n] = (byte)(keyMaterial[n] ^ pt[k++]);
                }
            }
            k = 0;
            while (j < keylen) {
                int n = j++;
                keyMaterial[n] = (byte)(keyMaterial[n] ^ ct[k++]);
            }
            ++i;
        }
        System.out.println("==========");
    }

    void cbcDecrypt() throws InvalidKeyException {
        int keylen = this.keySize / 8;
        byte[] keyMaterial = new byte[keylen];
        int size = this.cipher.defaultBlockSize();
        byte[] pt = new byte[size];
        byte[] ct = new byte[size];
        byte[] iv = new byte[size];
        System.out.println();
        System.out.println("=========================");
        System.out.println();
        System.out.println("Cipher Block Chaining (CBC) Mode - DECRYPTION");
        System.out.println("Monte Carlo Test");
        System.out.println();
        System.out.println("Algorithm Name: " + String.valueOf(this.cipherName));
        System.out.println();
        System.out.println("==========");
        System.out.println();
        System.out.println("KEYSIZE=" + String.valueOf(this.keySize));
        System.out.println();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        int i = 0;
        while (i < 400) {
            int k;
            System.out.println("I=" + String.valueOf(i));
            System.out.println("KEY=" + Util.toString(keyMaterial));
            System.out.println("IV=" + Util.toString(iv));
            System.out.println("CT=" + Util.toString(ct));
            map.put("gnu.crypto.cipher.key.material", keyMaterial);
            this.cipher.init(map);
            ++this.keyCount;
            int j = 0;
            while (j < 10000) {
                this.cipher.decryptBlock(ct, 0, pt, 0);
                ++this.decBlocks;
                k = 0;
                while (k < size) {
                    int n = k;
                    pt[n] = (byte)(pt[n] ^ iv[k]);
                    ++k;
                }
                System.arraycopy(ct, 0, iv, 0, size);
                System.arraycopy(pt, 0, ct, 0, size);
                ++j;
            }
            System.out.println("PT=" + Util.toString(pt));
            System.out.println();
            this.cipher.reset();
            j = 0;
            if (keylen > size) {
                int count = keylen - size;
                k = size - count;
                while (j < count) {
                    int n = j++;
                    keyMaterial[n] = (byte)(keyMaterial[n] ^ iv[k++]);
                }
            }
            k = 0;
            while (j < keylen) {
                int n = j++;
                keyMaterial[n] = (byte)(keyMaterial[n] ^ pt[k++]);
            }
            ++i;
        }
        System.out.println("==========");
    }
}

