/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.notification.internal.webpush;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.openhab.ui.habot.notification.internal.webpush.Utils;

public class HttpEce {
    private Map<String, KeyPair> keys;
    private Map<String, String> labels;

    public HttpEce(Map<String, KeyPair> keys, Map<String, String> labels) {
        this.keys = keys;
        this.labels = labels;
    }

    protected static byte[] buildInfo(String type, byte[] context) {
        ByteBuffer buffer = ByteBuffer.allocate(19 + type.length() + context.length);
        buffer.put("Content-Encoding: ".getBytes(StandardCharsets.UTF_8), 0, 18);
        buffer.put(type.getBytes(StandardCharsets.UTF_8), 0, type.length());
        buffer.put(new byte[1], 0, 1);
        buffer.put(context, 0, context.length);
        return buffer.array();
    }

    protected static byte[] hkdfExpand(byte[] ikm, byte[] salt, byte[] info, int length) throws InvalidKeyException, NoSuchAlgorithmException {
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hkdf.init((DerivationParameters)new HKDFParameters(ikm, salt, info));
        byte[] okm = new byte[length];
        hkdf.generateBytes(okm, 0, length);
        return okm;
    }

    public byte[][] deriveKey(byte[] salt, byte[] key, String keyId, PublicKey dh, byte[] authSecret, int padSize) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException, IllegalBlockSizeException, NoSuchProviderException, IOException {
        byte[] secret = null;
        byte[] context = null;
        if (key != null) {
            secret = key;
        } else if (dh != null) {
            byte[][] bytes = this.deriveDH(keyId, dh);
            secret = bytes[0];
            context = bytes[1];
        } else if (keyId != null) {
            secret = this.keys.get(keyId).getPublic().getEncoded();
        }
        if (secret == null) {
            throw new IllegalStateException("Unable to determine the secret");
        }
        if (authSecret != null) {
            secret = HttpEce.hkdfExpand(secret, authSecret, HttpEce.buildInfo("auth", new byte[0]), 32);
        }
        byte[] keyinfo = HttpEce.buildInfo("aesgcm", context);
        byte[] nonceinfo = HttpEce.buildInfo("nonce", context);
        byte[] hkdfKey = HttpEce.hkdfExpand(secret, salt, keyinfo, 16);
        byte[] hkdfNonce = HttpEce.hkdfExpand(secret, salt, nonceinfo, 12);
        return new byte[][]{hkdfKey, hkdfNonce};
    }

    private byte[][] deriveDH(String keyId, PublicKey publicKey) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, IOException {
        PublicKey senderPubKey = this.keys.get(keyId).getPublic();
        KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
        keyAgreement.init(this.keys.get(keyId).getPrivate());
        keyAgreement.doPhase(publicKey, true);
        byte[] secret = keyAgreement.generateSecret();
        byte[] context = this.concat(this.labels.get(keyId).getBytes(StandardCharsets.UTF_8), new byte[1], this.lengthPrefix(publicKey), this.lengthPrefix(senderPubKey));
        return new byte[][]{secret, context};
    }

    private byte[] lengthPrefix(Key key) throws IOException {
        byte[] bytes = Utils.savePublicKey((ECPublicKey)key);
        return this.concat(this.intToBytes(bytes.length), bytes);
    }

    private byte[] intToBytes(int x) throws IOException {
        byte[] bytes = new byte[2];
        bytes[1] = (byte)(x & 0xFF);
        bytes[0] = (byte)(x >> 8);
        return bytes;
    }

    private byte[] concat(byte[] ... arrays) {
        int lastPos = 0;
        byte[] combined = new byte[this.combinedLength(arrays)];
        byte[][] byArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] array = byArray[n2];
            System.arraycopy(array, 0, combined, lastPos, array.length);
            lastPos += array.length;
            ++n2;
        }
        return combined;
    }

    private int combinedLength(byte[] ... arrays) {
        int combinedLength = 0;
        byte[][] byArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] array = byArray[n2];
            combinedLength += array.length;
            ++n2;
        }
        return combinedLength;
    }

    public byte[] encrypt(byte[] buffer, byte[] salt, byte[] key, String keyid, PublicKey dh, byte[] authSecret, int padSize) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchProviderException, IOException {
        byte[][] derivedKey = this.deriveKey(salt, key, keyid, dh, authSecret, padSize);
        byte[] dkKey = derivedKey[0];
        byte[] dkNonce = derivedKey[1];
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        cipher.init(1, (Key)new SecretKeySpec(dkKey, "AES"), new GCMParameterSpec(128, dkNonce));
        cipher.update(new byte[padSize]);
        return cipher.doFinal(buffer);
    }
}

