/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.notification.internal;

import com.google.common.io.BaseEncoding;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.jose4j.lang.JoseException;
import org.openhab.ui.habot.notification.internal.SubscriptionProvider;
import org.openhab.ui.habot.notification.internal.webpush.Notification;
import org.openhab.ui.habot.notification.internal.webpush.PushService;
import org.openhab.ui.habot.notification.internal.webpush.Subscription;
import org.openhab.ui.habot.notification.internal.webpush.Utils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={NotificationService.class}, immediate=true)
public class NotificationService {
    private final Logger logger = LoggerFactory.getLogger(NotificationService.class);
    private static final String VAPID_KEYS_FILE_NAME = "habot" + File.separator + "vapid_keys";
    private static final String SUBJECT_NAME = "habot@openhab.org";
    private SubscriptionProvider subscriptionProvider;
    private String publicVAPIDKey;
    private String privateVAPIDKey;
    private PushService pushService = null;

    public NotificationService() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public String getVAPIDPublicKey() {
        this.loadVAPIDKeys();
        return this.publicVAPIDKey;
    }

    public void addSubscription(Subscription subscription) {
        if (this.subscriptionProvider.get(subscription.keys) == null) {
            this.subscriptionProvider.add(subscription);
        }
    }

    public void broadcastNotification(String payload) throws GeneralSecurityException {
        for (Subscription subscription : this.subscriptionProvider.getAll()) {
            this.sendNotification(subscription, payload);
        }
    }

    public Future<Response> sendNotification(Subscription subscription, String payload) throws GeneralSecurityException {
        this.getPushService();
        Notification notification = new Notification(subscription, payload);
        try {
            return this.pushService.send(notification);
        }
        catch (IOException | InterruptedException | ExecutionException | JoseException e) {
            this.logger.error("Unable to send the notification to {}: {}", (Object)this.subscriptionProvider.keyToString(subscription.keys), (Object)e.toString());
            return null;
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setSubscriptionProvider(SubscriptionProvider subscriptionProvider) {
        this.subscriptionProvider = subscriptionProvider;
    }

    protected void unsetSubscriptionProvider(SubscriptionProvider subscriptionProvider) {
        this.subscriptionProvider = null;
    }

    private void generateVAPIDKeyPair() throws InvalidAlgorithmParameterException, NoSuchProviderException, NoSuchAlgorithmException, FileNotFoundException, IOException {
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)"prime256v1");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)parameterSpec);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        byte[] publicKey = Utils.savePublicKey((ECPublicKey)keyPair.getPublic());
        byte[] privateKey = Utils.savePrivateKey((ECPrivateKey)keyPair.getPrivate());
        ArrayList<String> encodedKeys = new ArrayList<String>();
        encodedKeys.add(BaseEncoding.base64Url().encode(publicKey));
        encodedKeys.add(BaseEncoding.base64Url().encode(privateKey));
        File file = new File(String.valueOf(ConfigConstants.getUserDataFolder()) + File.separator + VAPID_KEYS_FILE_NAME);
        file.getParentFile().mkdirs();
        IOUtils.writeLines(encodedKeys, (String)System.lineSeparator(), (OutputStream)new FileOutputStream(file));
        this.publicVAPIDKey = (String)encodedKeys.get(0);
        this.privateVAPIDKey = (String)encodedKeys.get(1);
    }

    private void loadVAPIDKeys() {
        try {
            List encodedKeys = IOUtils.readLines((InputStream)new FileInputStream(String.valueOf(ConfigConstants.getUserDataFolder()) + File.separator + VAPID_KEYS_FILE_NAME));
            this.publicVAPIDKey = (String)encodedKeys.get(0);
            this.privateVAPIDKey = (String)encodedKeys.get(1);
        }
        catch (IOException e) {
            try {
                this.generateVAPIDKeyPair();
            }
            catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e1) {
                RuntimeException ex = new RuntimeException("Cannot get the VAPID keypair for push notifications");
                ex.initCause(e1);
                throw ex;
            }
        }
    }

    private PushService getPushService() throws GeneralSecurityException {
        if (this.pushService == null) {
            this.loadVAPIDKeys();
            this.pushService = new PushService(this.publicVAPIDKey, this.privateVAPIDKey, SUBJECT_NAME);
        }
        return this.pushService;
    }
}

