/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.notification;

import com.google.gson.Gson;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.handler.ActionHandler;
import org.openhab.core.automation.handler.BaseModuleHandler;
import org.openhab.ui.habot.notification.internal.NotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class WebPushNotificationActionHandler
extends BaseModuleHandler<Action>
implements ActionHandler {
    public static final String TYPE_ID = "habot.WebPushNotificationAction";
    protected static final String PARAM_TITLE = "title";
    protected static final String PARAM_BODY = "body";
    protected static final String PARAM_CARD_UID = "cardUID";
    protected static final String PARAM_TAGS = "tags";
    private final Logger logger = LoggerFactory.getLogger(WebPushNotificationActionHandler.class);
    private final NotificationService notificationService;

    public WebPushNotificationActionHandler(Action module, NotificationService notificationService) {
        super((Module)module);
        this.notificationService = notificationService;
    }

    public @Nullable Map<String, Object> execute(Map<String, Object> context) {
        String title = (String)((Action)this.module).getConfiguration().get(PARAM_TITLE);
        String body = (String)((Action)this.module).getConfiguration().get(PARAM_BODY);
        String cardUID = (String)((Action)this.module).getConfiguration().get(PARAM_CARD_UID);
        List tags = (List)((Action)this.module).getConfiguration().get(PARAM_TAGS);
        try {
            Gson gson = new Gson();
            HashMap<String, Object> payload = new HashMap<String, Object>();
            payload.put(PARAM_TITLE, title != null ? title : "HABot");
            payload.put(PARAM_BODY, body);
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (cardUID != null) {
                data.put(PARAM_CARD_UID, cardUID);
            }
            if (tags != null) {
                data.put(PARAM_TAGS, tags);
            }
            payload.put("data", data);
            String payloadJson = gson.toJson(payload);
            this.notificationService.broadcastNotification(payloadJson);
        }
        catch (GeneralSecurityException e) {
            this.logger.error("Error while sending the web push notification", (Throwable)e);
        }
        return null;
    }
}

