/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.nlp.internal.skill;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.types.Command;
import org.openhab.ui.habot.card.CardBuilder;
import org.openhab.ui.habot.nlp.AbstractItemIntentInterpreter;
import org.openhab.ui.habot.nlp.Intent;
import org.openhab.ui.habot.nlp.IntentInterpretation;
import org.openhab.ui.habot.nlp.ItemResolver;
import org.openhab.ui.habot.nlp.Skill;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Skill.class})
public class SetValueSkill
extends AbstractItemIntentInterpreter {
    private CardBuilder cardBuilder;
    private EventPublisher eventPublisher;

    @Override
    public String getIntentId() {
        return "set-value";
    }

    @Override
    public IntentInterpretation interpret(Intent intent, String language) {
        IntentInterpretation interpretation = new IntentInterpretation();
        Set<Item> matchedItems = this.findItems(intent);
        if (intent.getEntities().isEmpty()) {
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("general_failure"));
            return interpretation;
        }
        if (matchedItems == null || matchedItems.isEmpty()) {
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("answer_nothing_found"));
            interpretation.setHint(this.answerFormatter.getStandardTagHint(intent.getEntities()));
        } else {
            interpretation.setMatchedItems(matchedItems);
            if (intent.getEntities().containsKey("color")) {
                this.interpretSetColor(intent, language, interpretation, matchedItems);
            } else if (intent.getEntities().containsKey("value")) {
                this.interpretSetValue(intent, language, interpretation, matchedItems);
            } else {
                interpretation.setAnswer(this.answerFormatter.getRandomAnswer("value_misunderstood"));
            }
        }
        return interpretation;
    }

    private void interpretSetColor(Intent intent, String language, IntentInterpretation interpretation, Set<Item> matchedItems) {
        String hsbValue;
        String colorString = intent.getEntities().get("color");
        List<Item> filteredItems = matchedItems.stream().filter(i -> !(i instanceof GroupItem) && i.getAcceptedCommandTypes().contains(HSBType.class)).collect(Collectors.toList());
        try {
            ResourceBundle colors = ResourceBundle.getBundle("colors", new Locale(language));
            hsbValue = colors.getString("color_" + colorString);
        }
        catch (MissingResourceException e) {
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("set_color_unknown", (Map<String, String>)ImmutableMap.of((Object)"color", (Object)colorString)));
            return;
        }
        if (filteredItems.isEmpty()) {
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("set_color_no_item", (Map<String, String>)ImmutableMap.of((Object)"color", (Object)colorString)));
            interpretation.setHint(this.answerFormatter.getStandardTagHint(intent.getEntities()));
        } else if (filteredItems.size() == 1) {
            interpretation.setCard(this.cardBuilder.buildCard(intent, filteredItems));
            this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)filteredItems.get(0).getName(), (Command)new HSBType(hsbValue)));
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("set_color_single", (Map<String, String>)ImmutableMap.of((Object)"color", (Object)colorString)));
        } else {
            interpretation.setCard(this.cardBuilder.buildCard(intent, filteredItems));
            for (Item item : filteredItems) {
                this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)item.getName(), (Command)new HSBType(hsbValue)));
            }
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("set_color_multiple", (Map<String, String>)ImmutableMap.of((Object)"count", (Object)String.valueOf(filteredItems.size()), (Object)"color", (Object)colorString)));
        }
    }

    private void interpretSetValue(Intent intent, String language, IntentInterpretation interpretation, Set<Item> matchedItems) {
        String rawValue = intent.getEntities().get("value");
        String cleanedValue = rawValue.replaceAll("[^0-9\\.,]", "");
        List<Item> filteredItems = matchedItems.stream().filter(i -> !(i instanceof GroupItem) && i.getAcceptedCommandTypes().contains(DecimalType.class) || i.getAcceptedCommandTypes().contains(PercentType.class)).collect(Collectors.toList());
        if (filteredItems.isEmpty()) {
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("nothing_set_no_item", (Map<String, String>)ImmutableMap.of((Object)"value", (Object)rawValue)));
            interpretation.setHint(this.answerFormatter.getStandardTagHint(intent.getEntities()));
        } else if (filteredItems.size() == 1) {
            DecimalType value = ((Item)filteredItems.get(0)).getAcceptedCommandTypes().contains(DecimalType.class) ? DecimalType.valueOf((String)cleanedValue) : PercentType.valueOf((String)cleanedValue);
            interpretation.setCard(this.cardBuilder.buildCard(intent, filteredItems));
            this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)filteredItems.get(0).getName(), (Command)value));
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("set_value_single", (Map<String, String>)ImmutableMap.of((Object)"value", (Object)rawValue)));
        } else {
            interpretation.setCard(this.cardBuilder.buildCard(intent, filteredItems));
            for (Item item : filteredItems) {
                DecimalType value = item.getAcceptedCommandTypes().contains(DecimalType.class) ? DecimalType.valueOf((String)cleanedValue) : PercentType.valueOf((String)cleanedValue);
                this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)item.getName(), (Command)value));
            }
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("set_value_multiple", (Map<String, String>)ImmutableMap.of((Object)"count", (Object)String.valueOf(filteredItems.size()), (Object)"value", (Object)rawValue)));
        }
    }

    @Reference
    protected void setCardBuilder(CardBuilder cardBuilder) {
        this.cardBuilder = cardBuilder;
    }

    protected void unsetCardBuilder(CardBuilder cardBuilder) {
        this.cardBuilder = null;
    }

    @Reference
    protected void setItemResolver(ItemResolver itemResolver) {
        this.itemResolver = itemResolver;
    }

    protected void unsetItemResolver(ItemResolver itemResolver) {
        this.itemResolver = null;
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }
}

