/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.nlp.internal.skill;

import java.util.Set;
import org.eclipse.smarthome.core.items.Item;
import org.openhab.ui.habot.card.CardBuilder;
import org.openhab.ui.habot.nlp.AbstractItemIntentInterpreter;
import org.openhab.ui.habot.nlp.Intent;
import org.openhab.ui.habot.nlp.IntentInterpretation;
import org.openhab.ui.habot.nlp.ItemResolver;
import org.openhab.ui.habot.nlp.Skill;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Skill.class})
public class HistoryHourlyGraphSkill
extends AbstractItemIntentInterpreter {
    private CardBuilder cardBuilder;

    @Override
    public String getIntentId() {
        return "get-history-hourly";
    }

    @Override
    public IntentInterpretation interpret(Intent intent, String language) {
        IntentInterpretation interpretation = new IntentInterpretation();
        Set<Item> matchedItems = this.findItems(intent);
        if (intent.getEntities().isEmpty()) {
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("general_failure"));
            return interpretation;
        }
        if (matchedItems == null || matchedItems.isEmpty()) {
            interpretation.setAnswer(this.answerFormatter.getRandomAnswer("answer_nothing_found"));
            interpretation.setHint(this.answerFormatter.getStandardTagHint(intent.getEntities()));
        } else {
            interpretation.setMatchedItems(matchedItems);
            String period = "h";
            if (intent.getEntities().containsKey("period")) {
                period = intent.getEntities().get("period").concat(period);
            }
            interpretation.setCard(this.cardBuilder.buildChartCard(intent, matchedItems, period));
        }
        interpretation.setAnswer(this.answerFormatter.getRandomAnswer("info_found_simple"));
        return interpretation;
    }

    @Reference
    protected void setCardBuilder(CardBuilder cardBuilder) {
        this.cardBuilder = cardBuilder;
    }

    protected void unsetCardBuilder(CardBuilder cardBuilder) {
        this.cardBuilder = null;
    }

    @Reference
    protected void setItemResolver(ItemResolver itemResolver) {
        this.itemResolver = itemResolver;
    }

    protected void unsetItemResolver(ItemResolver itemResolver) {
        this.itemResolver = null;
    }
}

