/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.nlp.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemPredicates;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.Metadata;
import org.eclipse.smarthome.core.items.MetadataKey;
import org.eclipse.smarthome.core.items.MetadataRegistry;
import org.eclipse.smarthome.core.semantics.SemanticTags;
import org.eclipse.smarthome.core.semantics.SemanticsPredicates;
import org.eclipse.smarthome.core.semantics.SemanticsService;
import org.eclipse.smarthome.core.semantics.model.Location;
import org.eclipse.smarthome.core.semantics.model.Property;
import org.openhab.ui.habot.nlp.ItemNamedAttribute;
import org.openhab.ui.habot.nlp.ItemResolver;
import org.openhab.ui.habot.nlp.UnsupportedLanguageException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ItemResolver.class}, immediate=true)
public class SemanticsItemResolver
implements ItemResolver {
    private static final String SYNONYMS_NAMESPACE = "synonyms";
    private ItemRegistry itemRegistry;
    private MetadataRegistry metadataRegistry;
    private SemanticsService semanticsService;
    private Locale currentLocale = null;

    @Override
    public void setLocale(Locale locale) {
        this.currentLocale = locale == null || locale.getLanguage().equals(Locale.ENGLISH.getLanguage()) ? Locale.ROOT : locale;
    }

    @Override
    public Stream<Item> getMatchingItems(String object, String location) {
        Stream<Object> items = location != null ? this.semanticsService.getItemsInLocation(location, this.currentLocale).stream() : new HashSet(this.itemRegistry.getAll()).stream();
        if (object != null) {
            List semanticTagTypes = SemanticTags.getByLabelOrSynonym((String)object, (Locale)this.currentLocale);
            if (!semanticTagTypes.isEmpty() && semanticTagTypes.stream().noneMatch(t -> Location.class.isAssignableFrom((Class<?>)t))) {
                Predicate tagsPredicate = null;
                for (Class tag : semanticTagTypes) {
                    Predicate tagPredicate = Property.class.isAssignableFrom(tag) ? SemanticsPredicates.relatesTo((Class)tag) : SemanticsPredicates.isA((Class)tag);
                    Predicate predicate = tagsPredicate = tagsPredicate == null ? tagPredicate : tagsPredicate.or(tagPredicate);
                }
                items = items.filter(ItemPredicates.hasLabel((String)object).or(this.hasSynonym(object)).or(tagsPredicate));
            } else {
                return items.filter(ItemPredicates.hasLabel((String)object).or(this.hasSynonym(object)).and(SemanticsPredicates.isLocation().negate()));
            }
        }
        return items;
    }

    @Override
    public Map<Item, Set<ItemNamedAttribute>> getAllItemNamedAttributes() throws UnsupportedLanguageException {
        if (this.currentLocale == null) {
            throw new UnsupportedLanguageException(this.currentLocale);
        }
        HashMap<Item, Set<ItemNamedAttribute>> attributes = new HashMap<Item, Set<ItemNamedAttribute>>();
        for (Item item : this.itemRegistry.getAll()) {
            MetadataKey key;
            Metadata md;
            Class semanticType = SemanticTags.getSemanticType((Item)item);
            if (semanticType == null) continue;
            HashSet<ItemNamedAttribute> itemAttributes = new HashSet<ItemNamedAttribute>();
            attributes.put(item, new HashSet());
            String attributeType = Location.class.isAssignableFrom(semanticType) ? "location" : "object";
            itemAttributes.add(new ItemNamedAttribute(attributeType, item.getLabel(), ItemNamedAttribute.AttributeSource.LABEL));
            for (String tagLabel : SemanticTags.getLabelAndSynonyms((Class)semanticType, (Locale)this.currentLocale)) {
                itemAttributes.add(new ItemNamedAttribute(attributeType, tagLabel, ItemNamedAttribute.AttributeSource.TAG));
            }
            Class relatedProperty = SemanticTags.getProperty((Item)item);
            if (relatedProperty != null) {
                for (String propertyLabel : SemanticTags.getLabelAndSynonyms((Class)relatedProperty, (Locale)this.currentLocale)) {
                    itemAttributes.add(new ItemNamedAttribute("object", propertyLabel, ItemNamedAttribute.AttributeSource.TAG));
                }
            }
            if ((md = (Metadata)this.metadataRegistry.get((Object)(key = new MetadataKey(SYNONYMS_NAMESPACE, item.getName())))) != null) {
                String[] synonyms;
                String[] stringArray = synonyms = md.getValue().split(",");
                int n = synonyms.length;
                int n2 = 0;
                while (n2 < n) {
                    String synonym = stringArray[n2];
                    itemAttributes.add(new ItemNamedAttribute(attributeType, synonym.trim(), ItemNamedAttribute.AttributeSource.METADATA));
                    ++n2;
                }
            }
            itemAttributes.removeIf(attribute -> attribute.getValue() == null || attribute.getValue().isEmpty());
            attributes.put(item, itemAttributes);
        }
        return attributes;
    }

    private Predicate<? super Item> hasSynonym(String labelOrSynonym) {
        return item -> {
            MetadataKey key = new MetadataKey(SYNONYMS_NAMESPACE, item.getName());
            Metadata md = (Metadata)this.metadataRegistry.get((Object)key);
            if (md != null) {
                String[] synonyms;
                String[] stringArray = synonyms = md.getValue().split(",");
                int n = synonyms.length;
                int n2 = 0;
                while (n2 < n) {
                    String synonym = stringArray[n2];
                    if (synonym.equalsIgnoreCase(labelOrSynonym)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        };
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        if (this.itemRegistry == null) {
            this.itemRegistry = itemRegistry;
        }
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        if (itemRegistry == this.itemRegistry) {
            this.itemRegistry = null;
        }
    }

    @Reference
    protected void setMetadataRegistry(MetadataRegistry metadataRegistry) {
        if (this.metadataRegistry == null) {
            this.metadataRegistry = metadataRegistry;
        }
    }

    protected void unsetMetadataRegistry(MetadataRegistry metadataRegistry) {
        if (metadataRegistry == this.metadataRegistry) {
            this.metadataRegistry = null;
        }
    }

    @Reference
    public void setSemanticsService(SemanticsService semanticsService) {
        this.semanticsService = semanticsService;
    }

    public void unsetSemanticsService(SemanticsService semanticsService) {
        this.semanticsService = null;
    }
}

