/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.nlp.internal;

import java.io.IOException;
import java.util.Vector;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.ObjectStream;

public class IntentDocumentSampleStream
implements ObjectStream<DocumentSample> {
    String category;
    ObjectStream<String> stream;

    public IntentDocumentSampleStream(String category, ObjectStream<String> stream) {
        this.category = category;
        this.stream = stream;
    }

    public DocumentSample read() throws IOException {
        String sampleString = (String)this.stream.read();
        if (sampleString != null) {
            Object[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(sampleString);
            Vector<String> vector = new Vector<String>(tokens.length);
            Object[] objectArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = objectArray[n2];
                if (!token.startsWith("<")) {
                    vector.add(token);
                }
                ++n2;
            }
            tokens = new String[vector.size()];
            vector.copyInto(tokens);
            if (tokens.length <= 0) {
                throw new IOException("Empty lines are not allowed!");
            }
            DocumentSample sample = new DocumentSample(this.category, (String[])tokens);
            return sample;
        }
        return null;
    }

    public void reset() throws IOException, UnsupportedOperationException {
        this.stream.reset();
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

