/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.nlp;

import java.io.InputStream;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.openhab.ui.habot.nlp.Intent;
import org.openhab.ui.habot.nlp.ItemResolver;
import org.openhab.ui.habot.nlp.Skill;
import org.openhab.ui.habot.nlp.UnsupportedLanguageException;
import org.openhab.ui.habot.nlp.internal.AnswerFormatter;

public abstract class AbstractItemIntentInterpreter
implements Skill {
    protected ItemRegistry itemRegistry;
    protected ItemResolver itemResolver;
    protected AnswerFormatter answerFormatter;

    protected Set<Item> findItems(Intent intent) {
        String object = intent.getEntities().get("object");
        String location = intent.getEntities().get("location");
        Set<Item> items = this.itemResolver.getMatchingItems(object, location).collect(Collectors.toSet());
        Item[] itemArray = items.toArray(new Item[0]);
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (item instanceof GroupItem) {
                GroupItem gItem = (GroupItem)item;
                items.addAll(gItem.getMembers());
            }
            ++n2;
        }
        return items;
    }

    @Override
    public InputStream getTrainingData(String language) throws UnsupportedLanguageException {
        this.answerFormatter = new AnswerFormatter(language);
        InputStream trainingData = Skill.class.getClassLoader().getResourceAsStream("train/" + language + "/" + this.getIntentId() + ".txt");
        if (trainingData == null) {
            throw new UnsupportedLanguageException(language);
        }
        return trainingData;
    }
}

