/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.habot.dashboard.internal;

import java.util.Map;
import org.openhab.ui.dashboard.DashboardTile;
import org.openhab.ui.habot.dashboard.internal.HABotHttpContext;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DashboardTile.class}, immediate=true, name="org.openhab.habot", property={"service.config.description.uri=ui:habot", "service.config.label=HABot", "service.config.category=ui"})
public class HABotDashboardTile
implements DashboardTile {
    public static final String HABOT_ALIAS = "/habot";
    public static final String RESOURCES_BASE = "web/dist/pwa-mat";
    private final Logger logger = LoggerFactory.getLogger(HABotDashboardTile.class);
    protected HttpService httpService;

    public String getName() {
        return "HABot";
    }

    public String getUrl() {
        return "../habot/";
    }

    public String getOverlay() {
        return null;
    }

    public String getImageUrl() {
        return "../habot/statics/dashboardtile.png";
    }

    @Activate
    protected void activate(Map<String, Object> configProps, BundleContext context) {
        try {
            Object useGzipCompression = configProps.get("useGzipCompression");
            HABotHttpContext httpContext = new HABotHttpContext(this.httpService.createDefaultHttpContext(), RESOURCES_BASE, useGzipCompression != null && Boolean.parseBoolean(useGzipCompression.toString()));
            this.httpService.registerResources(HABOT_ALIAS, RESOURCES_BASE, (HttpContext)httpContext);
            this.logger.info("Started HABot at /habot");
        }
        catch (NamespaceException e) {
            this.logger.error("Error during HABot startup: {}", (Object)e.getMessage());
        }
    }

    @Deactivate
    protected void deactivate() {
        this.httpService.unregister(HABOT_ALIAS);
        this.logger.info("Stopped HABot");
    }

    @Reference
    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }
}

