/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.basic.internal.render;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.model.sitemap.sitemap.Chart;
import org.eclipse.smarthome.model.sitemap.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.openhab.ui.basic.internal.render.AbstractWidgetRenderer;
import org.openhab.ui.basic.render.RenderException;
import org.openhab.ui.basic.render.WidgetRenderer;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WidgetRenderer.class})
public class ChartRenderer
extends AbstractWidgetRenderer {
    private final Logger logger = LoggerFactory.getLogger(ChartRenderer.class);
    private static final String URL_NONE_ICON = "images/none.png";

    @Override
    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        super.deactivate(bundleContext);
    }

    @Override
    public boolean canRender(Widget w) {
        return w instanceof Chart;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        Chart chart = (Chart)w;
        try {
            boolean ignoreRefresh;
            String url;
            String itemParam = null;
            Item item = this.itemUIRegistry.getItem(chart.getItem());
            itemParam = item instanceof GroupItem ? "groups=" + chart.getItem() : "items=" + chart.getItem();
            String chartUrl = "/chart?" + itemParam + "&period=" + chart.getPeriod();
            if (chart.getService() != null) {
                chartUrl = String.valueOf(chartUrl) + "&service=" + chart.getService();
            }
            if (chart.getLegend() != null) {
                chartUrl = chart.getLegend() != false ? String.valueOf(chartUrl) + "&legend=true" : String.valueOf(chartUrl) + "&legend=false";
            }
            String chartTheme = null;
            switch (this.config.getTheme()) {
                case "default": {
                    chartTheme = "bright";
                    break;
                }
                case "dark": {
                    chartTheme = "dark";
                }
            }
            if (chartTheme != null) {
                chartUrl = String.valueOf(chartUrl) + "&theme=" + chartTheme;
            }
            if (!this.itemUIRegistry.getVisiblity(w)) {
                url = URL_NONE_ICON;
                ignoreRefresh = true;
            } else {
                url = String.valueOf(chartUrl) + "&t=" + new Date().getTime();
                ignoreRefresh = false;
            }
            String snippet = this.getSnippet("chart");
            snippet = this.preprocessSnippet(snippet, w);
            snippet = chart.getRefresh() > 0 ? StringUtils.replace((String)snippet, (String)"%update_interval%", (String)Integer.toString(chart.getRefresh())) : StringUtils.replace((String)snippet, (String)"%update_interval%", (String)"0");
            snippet = StringUtils.replace((String)snippet, (String)"%id%", (String)this.itemUIRegistry.getWidgetId(w));
            snippet = StringUtils.replace((String)snippet, (String)"%proxied_url%", (String)chartUrl);
            snippet = StringUtils.replace((String)snippet, (String)"%valid_url%", (String)"true");
            snippet = StringUtils.replace((String)snippet, (String)"%ignore_refresh%", (String)(ignoreRefresh ? "true" : "false"));
            snippet = StringUtils.replace((String)snippet, (String)"%url%", (String)url);
            sb.append(snippet);
        }
        catch (ItemNotFoundException e) {
            this.logger.warn("Chart cannot be rendered as item '{}' does not exist.", (Object)chart.getItem());
        }
        return null;
    }

    @Override
    @Reference
    protected void setItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.setItemUIRegistry(ItemUIRegistry2);
    }

    @Override
    protected void unsetItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.unsetItemUIRegistry(ItemUIRegistry2);
    }
}

