/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.property.editor;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImageDialog;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.ImageInfo;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.ClasspathImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.DefaultImagePage;
import org.eclipse.wb.internal.core.xml.Activator;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.xml.model.property.GenericProperty;

public final class ImagePropertyEditor
extends TextDialogPropertyEditor
implements IClipboardSourceProvider {
    public static final PropertyEditor INSTANCE = new ImagePropertyEditor();

    private ImagePropertyEditor() {
    }

    protected String getText(Property property) throws Exception {
        return ((GenericProperty)property).getExpression();
    }

    public String getClipboardSource(GenericProperty property) throws Exception {
        return property.getExpression();
    }

    protected void openDialog(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        EditorContext context = genericProperty.getObject().getContext();
        IJavaProject javaProject = context.getJavaProject();
        String packagePath = ImagePropertyEditor.getContextPackagePath(context);
        ImageDialog imageDialog = new ImageDialog(javaProject);
        String text = this.getText(property);
        if (text == null) {
            imageDialog.setInput("DEFAULT", null);
        } else {
            if (!text.startsWith("/")) {
                text = String.valueOf(packagePath) + text;
            }
            imageDialog.setInput("CLASSPATH", text);
        }
        if (imageDialog.open() == 0) {
            ImageInfo imageInfo = imageDialog.getImageInfo();
            String expression = null;
            String pageId = imageInfo.getPageId();
            if (pageId != "DEFAULT") {
                expression = "/" + imageInfo.getData();
                expression = StringUtils.removeStart((String)expression, (String)packagePath);
            }
            genericProperty.setExpression(expression, Property.UNKNOWN_VALUE);
        }
    }

    private static String getContextPackagePath(EditorContext context) {
        String packagePath = "/";
        IContainer packageFolder = context.getFile().getParent();
        IJavaElement javaElement = JavaCore.create((IResource)packageFolder);
        if (javaElement instanceof IPackageFragment) {
            IPackageFragment packageFragment = (IPackageFragment)javaElement;
            packagePath = String.valueOf(packagePath) + packageFragment.getElementName().replace('.', '/') + "/";
        }
        return packagePath;
    }

    private static final class ImageDialog
    extends AbstractImageDialog {
        private final IJavaProject m_javaProject;

        protected ImageDialog(IJavaProject javaProject) {
            super(DesignerPlugin.getShell(), (AbstractUIPlugin)Activator.getDefault());
            this.m_javaProject = javaProject;
        }

        protected void addPages(Composite parent) {
            this.addPage((AbstractImagePage)new ClasspathImagePage(parent, 0, (AbstractImageDialog)this, this.m_javaProject));
            this.addPage((AbstractImagePage)new DefaultImagePage(parent, 0, (AbstractImageDialog)this));
        }
    }
}

