/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.model.variable.AbstractSimpleVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.dialogfields.AbstractValidationTitleAreaDialog;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogFieldUtils;
import org.eclipse.wb.internal.core.utils.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.wb.internal.core.utils.dialogfields.StringDialogField;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public final class ExposeComponentSupport {
    public static void contribute(JavaInfo component, IContributionManager manager, String text) {
        VariableSupport variableSupport = component.getVariableSupport();
        if (!(variableSupport instanceof AbstractSimpleVariableSupport)) {
            return;
        }
        AstEditor editor = component.getEditor();
        TypeDeclaration typeDeclaration = ExposeComponentSupport.getTypeDeclaration(component);
        MethodDeclaration[] methodDeclarationArray = typeDeclaration.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration method = methodDeclarationArray[n2];
            List<Statement> statements = DomGenerics.statements(method);
            if (statements.size() == 1 && statements.get(0) instanceof ReturnStatement) {
                ReturnStatement returnStatement = (ReturnStatement)statements.get(0);
                if (variableSupport.hasName()) {
                    String name = variableSupport.getName();
                    Expression expression = returnStatement.getExpression();
                    if (expression != null && editor.getSource((ASTNode)expression).equals(name)) {
                        return;
                    }
                }
            }
            ++n2;
        }
        manager.appendToGroup("org.eclipse.wb.popup.group.inheritance", (IAction)new ExposeAction(component, text));
    }

    private static TypeDeclaration getTypeDeclaration(JavaInfo component) {
        AstEditor editor = component.getEditor();
        return EditorState.get(editor).getFlowDescription().geTypeDeclaration();
    }

    private static void expose(JavaInfo component, String methodName, String modifier) throws Exception {
        AstEditor editor = component.getEditor();
        TypeDeclaration typeDeclaration = ExposeComponentSupport.getTypeDeclaration(component);
        BodyDeclarationTarget methodTarget = new BodyDeclarationTarget(typeDeclaration, false);
        String headerSource = MessageFormat.format("{0} {1} {2}()", modifier, component.getDescription().getComponentClass().getName(), methodName);
        String returnSource = TemplateUtils.resolve(methodTarget, "return {0};", new Object[]{component});
        editor.addMethodDeclaration(headerSource, (List<String>)ImmutableList.of((Object)returnSource), methodTarget);
    }

    private static final class ExposeAction
    extends Action {
        private final JavaInfo m_component;

        public ExposeAction(JavaInfo component, String text) {
            this.m_component = component;
            this.setText(text);
            this.setImageDescriptor(DesignerPlugin.getImageDescriptor((String)"actions/expose/exposeComponent.png"));
        }

        public void run() {
            final ExposeDialog dialog = new ExposeDialog(this.m_component);
            if (dialog.open() == 0) {
                ExecutionUtils.run((ObjectInfo)this.m_component, (RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        ExposeComponentSupport.expose(m_component, dialog.getName(), dialog.isPublic() ? "public" : "protected");
                    }
                });
            }
        }
    }

    private static class ExposeDialog
    extends AbstractValidationTitleAreaDialog {
        private final JavaInfo m_component;
        private StringDialogField m_nameField;
        private SelectionButtonDialogFieldGroup m_modifierField;
        private Composite m_fieldsContainer;

        public ExposeDialog(JavaInfo component) {
            super(DesignerPlugin.getShell(), (AbstractUIPlugin)DesignerPlugin.getDefault(), ModelMessages.ExposeComponentSupport_shellTitle, ModelMessages.ExposeComponentSupport_title, DesignerPlugin.getImage((String)"actions/expose/expose_banner.gif"), ModelMessages.ExposeComponentSupport_message);
            this.m_component = component;
        }

        protected void createControls(Composite container) {
            this.m_fieldsContainer = container;
            GridLayoutFactory.create((Composite)container).columns(2);
            this.m_nameField = new StringDialogField();
            this.doCreateField((DialogField)this.m_nameField, ModelMessages.ExposeComponentSupport_methodLabel);
            String componentName = this.m_component.getVariableSupport().getComponentName();
            this.m_nameField.setText("get" + StringUtils.capitalize((String)componentName));
            this.m_modifierField = new SelectionButtonDialogFieldGroup(16, new String[]{"&public", "pro&tected"}, 1, 16);
            this.doCreateField((DialogField)this.m_modifierField, ModelMessages.ExposeComponentSupport_modifierLabel);
        }

        protected String validate() {
            String methodName = this.m_nameField.getText();
            String methodSignature = String.valueOf(methodName) + "()";
            if (AstNodeUtils.getMethodBySignature(ExposeComponentSupport.getTypeDeclaration(this.m_component), methodSignature) != null) {
                return MessageFormat.format(ModelMessages.ExposeComponentSupport_methodAlreadyExists, methodSignature);
            }
            return null;
        }

        public String getName() {
            return this.m_nameField.getText();
        }

        public boolean isPublic() {
            return this.m_modifierField.getSelection()[0] == 0;
        }

        protected final void doCreateField(DialogField dialogField, String labelText) {
            dialogField.setLabelText(labelText);
            dialogField.setDialogFieldListener(this.m_validateListener);
            DialogFieldUtils.fillControls((Composite)this.m_fieldsContainer, (DialogField)dialogField, (int)2, (int)60);
        }
    }
}

