/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.property;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.ObjectProperty;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;

public abstract class XmlProperty
extends ObjectProperty {
    protected final XmlObjectInfo m_object;
    private final String m_title;

    public XmlProperty(XmlObjectInfo object, String title, PropertyEditor propertyEditor) {
        this(object, title, PropertyCategory.NORMAL, propertyEditor);
    }

    public XmlProperty(XmlObjectInfo object, String title, PropertyCategory category, PropertyEditor propertyEditor) {
        super(propertyEditor);
        this.m_object = object;
        this.m_title = title;
        this.setCategory(category);
    }

    public final String getTitle() {
        return this.m_title;
    }

    public final ObjectInfo getObjectInfo() {
        return this.m_object;
    }

    public final XmlObjectInfo getObject() {
        return this.m_object;
    }

    public void setValue(final Object value) throws Exception {
        ExecutionUtils.run((ObjectInfo)this.m_object, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                XmlProperty.this.setValueEx(value);
            }
        });
    }

    protected void setValueEx(Object value) throws Exception {
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IJavaProject.class) {
            return adapter.cast(this.m_object.getContext().getJavaProject());
        }
        if (adapter == ObjectInfo.class) {
            return adapter.cast((Object)this.m_object);
        }
        return (T)super.getAdapter(adapter);
    }
}

