/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d.scroll;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class ScrollModel
implements Listener {
    private final ScrollBar m_scrollBar;
    protected int m_selection;
    private int m_extent;
    private List<ISelectionListener> m_listeners;

    public ScrollModel(ScrollBar scrollBar) {
        if (scrollBar != null) {
            scrollBar.setMinimum(0);
            scrollBar.setIncrement(1);
            scrollBar.setEnabled(false);
            scrollBar.setVisible(false);
            scrollBar.addListener(13, (Listener)this);
        }
        this.m_scrollBar = scrollBar;
    }

    public int getSelection() {
        return this.m_selection;
    }

    public void setSelection(int selection) {
        this.m_selection = selection;
    }

    public void configure(int available, int preferred) {
        if (this.m_scrollBar == null) {
            return;
        }
        try {
            if (preferred > available) {
                this.m_extent = preferred - available;
                this.m_selection = Math.max(0, Math.min(this.m_extent, this.m_selection));
                this.m_scrollBar.setValues(this.m_selection, 0, preferred, available, available / 20, available * 3 / 4);
                if (this.m_scrollBar.getEnabled()) {
                    return;
                }
                this.m_scrollBar.setSelection(0);
                this.m_scrollBar.setEnabled(true);
                this.m_scrollBar.setVisible(true);
            } else {
                this.m_scrollBar.setVisible(false);
                this.m_scrollBar.setEnabled(false);
                this.m_scrollBar.setSelection(0);
            }
            this.m_selection = 0;
        }
        finally {
            this.fireSetSelection(this.m_selection);
        }
    }

    protected abstract void handlePositiveScrolling(int var1, int var2);

    protected abstract void handleNegativeScrolling(int var1, int var2);

    public void handleEvent(Event event) {
        if (this.m_scrollBar.getEnabled()) {
            int selection = Math.max(0, Math.min(this.m_extent, this.m_scrollBar.getSelection()));
            this.m_scrollBar.setSelection(selection);
            int delta = selection - this.m_selection;
            if (delta == 0) {
                return;
            }
            if (delta > 0) {
                this.handlePositiveScrolling(delta, selection);
            } else {
                this.handleNegativeScrolling(-delta, selection);
            }
            this.fireSetSelection(selection);
        }
    }

    public void addSelectionListener(ISelectionListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = Lists.newArrayList();
        }
        this.m_listeners.add(listener);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.m_listeners.remove(listener);
    }

    private void fireSetSelection(int selection) {
        if (this.m_listeners != null) {
            for (ISelectionListener listener : this.m_listeners) {
                listener.setSelection(selection);
            }
        }
    }

    public static interface ISelectionListener {
        public void setSelection(int var1);
    }
}

