/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.snapping;

import java.util.List;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.geometry.Interval;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.gef.policy.snapping.ComponentSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.IFeedbackProxy;
import org.eclipse.wb.internal.core.gef.policy.snapping.IVisualDataProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;

public class IndentedComponentSnapPoint
extends ComponentSnapPoint {
    public static final int INDENT = 10;

    public IndentedComponentSnapPoint(IVisualDataProvider visualDataProvider, IAbstractComponentInfo anchorComponent) {
        super(visualDataProvider, anchorComponent, 1, 0);
    }

    @Override
    protected void calculateSnapPoint(List<? extends IAbstractComponentInfo> beingSnappedList) {
        super.calculateSnapPoint(beingSnappedList);
        this.m_gap = this.m_visualDataProvider.getComponentGapValue(this.getNearestComponentToSide(beingSnappedList), this.m_anchorComponent, 32);
        this.m_snapPoint = this.m_anchorChildBounds.x + 10;
    }

    @Override
    protected Interval getXSnapInterval() {
        return new Interval(this.m_anchorChildBounds.x, this.m_anchorChildBounds.width);
    }

    @Override
    protected Interval getYSnapInterval() {
        return new Interval(this.m_anchorChildBounds.bottom(), this.m_gap * 2);
    }

    @Override
    public void addFeedback(Rectangle snappedBounds, IFeedbackProxy feedbackProxy, List<Figure> feedbacks) {
        Rectangle anchorChildBounds = PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, this.m_anchorComponent);
        Rectangle expCandidateBounds = anchorChildBounds.getCopy().expand(0, 8);
        feedbacks.add(feedbackProxy.addVerticalFeedbackLine(expCandidateBounds.x, expCandidateBounds.y, expCandidateBounds.height));
        Rectangle expBounds = snappedBounds.getCopy().expand(0, 8);
        feedbacks.add(feedbackProxy.addVerticalFeedbackLine(snappedBounds.x, expBounds.y, expBounds.height));
    }

    @Override
    protected boolean checkDirection() {
        return false;
    }
}

